use salarymarket;
ALTER TABLE solution_subscription
MODIFY COLUMN subscription_type ENUM('On The Menu', 'Essential', 'Advanced', 'Solution') NOT NULL;

INSERT INTO solution_subscription (id, subscription_code, subscription_type) VALUES
(4, 'solution', 'Solution');

INSERT INTO solution_subscription_menu (subscriptionCode, menuCode) VALUES
('solution', 'home'),
('solution', 'home_indicators'),
('solution', 'home_indicateurs_number_of_employees'),
('solution', 'home_administration_employees_per_gender'),
('solution', 'home_indicateurs_payroll'),
('solution', 'home_indicateurs_median_salaries_by_career_path'),
('solution', 'home_indicateurs_supervision_rate'),
('solution', 'company_compensation'),
('solution', 'company_quiz'),
('solution', 'quiz_selected_sector'),
('solution', 'quiz_market'),
('solution', 'report'),
('solution', 'myCompany'),
('solution', 'myCompany_informations'),
('solution', 'myCompany_users'),
('solution', 'myCompany_entities'),
('solution', 'myCompany_profiles'),
('solution', 'myCompany_configuration'),
('solution', 'myCompany_settings'),
('solution', 'myCompany_settings_language');

INSERT INTO solution_subscription_menu_rights (subscriptionCode, menuCode, solution_menu_rights_code) VALUES
-- Solution
-- Compensation
('solution', 'company_compensation', 'compensation_search'),
('solution', 'company_compensation', 'compensation_configuration'),
('solution', 'company_compensation', 'compensation_import'),
('solution', 'company_compensation', 'compensation_export'),
('solution', 'company_compensation', 'compensation_create'),
('solution', 'company_compensation', 'compensation_delete'),
('solution', 'company_compensation', 'compensation_update'),
('solution', 'company_compensation', 'compensation_view'),

-- quiz
('solution', 'company_quiz', 'quiz_Submit'),
('solution', 'company_quiz', 'quiz_View'),
-- report
('solution', 'report', 'report_create'),
('solution', 'report', 'report_View'),
('solution', 'report', 'report_delete'),
('solution', 'report', 'report_upload'),
-- Informations
('solution', 'myCompany_informations', 'company_Informations_update'),
-- Users
('solution', 'myCompany_users', 'company_user_create'),
('solution', 'myCompany_users', 'company_user_update'),
('solution', 'myCompany_users', 'company_user_delete'),
('solution', 'myCompany_users', 'company_user_desactivate'),
('solution', 'myCompany_users', 'company_user_activity'),
('solution', 'myCompany_users', 'company_user_view'),
-- entities
('solution', 'myCompany_entities', 'company_entity_create'),
('solution', 'myCompany_entities', 'company_entity_update'),
('solution', 'myCompany_entities', 'company_entity_delete'),
('solution', 'myCompany_entities', 'company_entity_view'),
-- profiles
('solution', 'myCompany_profiles', 'company_profil_Create'),
('solution', 'myCompany_profiles', 'company_profil_update'),
('solution', 'myCompany_profiles', 'company_profil_delete'),
('solution', 'myCompany_profiles', 'company_profil_view'),
-- languages
('solution', 'myCompany_settings_language', 'company_language_activate');