use salarymarket;
 
INSERT INTO solution_questionnaire (id, title, description, countryCode,quiz_image, questionnaire_order) VALUES 
(3, 'Questionnaire 3 -Attraction, Rétention et fin de contrat',
'Évaluation des stratégies d\'attraction et de rétention des talents, ainsi que des processus de fin de contrat','TN',
'Questionnaire 3 -Attraction, Rétention et fin de contrat.jpg', 3);

-- Insert into questionnaire_section for Questionnaire 3 Attraction, Rétention et fin de contrat
INSERT INTO solution_questionnaire_section (title, questionnaireId, section_order)  VALUES 
('Stratégies d\'Attraction des Talents', 3, 1),
('Stratégies de Rétention des Talents', 3, 2),
('Cessation d\'Emploi', 3, 3);

-- Insert questions with explicit IDs to match the question items
INSERT INTO solution_questionnaire_questions 
  (question, sectionId, questionnaireId, idparent, type, question_order, echartType) 
VALUES
  -- Section 1: Stratégies d'Attraction des Talents
  ('Quels canaux de recrutement utilisez-vous pour attirer de nouveaux talents ?', 8, 3, NULL, 'CM', 1, 'Bar'),
  ('Quels éléments de votre entreprise sont les plus attractifs pour les candidats potentiels ?', 8, 3, NULL, 'CM', 2, 'Bar'),
  ( 'Quelles initiatives mettez-vous en place pour faciliter l''intégration des nouveaux employés ?', 8, 3, NULL, 'CM', 3, 'Bar'),
  ('Comment travaillez-vous à améliorer la marque employeur de votre entreprise ?', 8, 3, NULL, 'CM', 4, 'Bar'),
  
  -- Section 2: Stratégies de Rétention des Talents
  ('Quels sont les principaux éléments qui contribuent à la satisfaction et à l''engagement des employés dans votre entreprise ?', 9, 3, NULL, 'CM', 5, 'Bar'),
  ( 'Quels programmes spécifiques avez-vous mis en place pour retenir vos talents clés ?', 9, 3, NULL, 'CM', 6, 'Bar'),
  ( 'Réalisez-vous des enquêtes de satisfaction et d’engagement des employés ?', 9, 3, NULL, 'CU', 7, 'Pie'),
  ( 'A quelle fréquence réalisez-vous les enquêtes de satisfaction et d’engagement des employés ?', 9, 3, 31, 'CU', 8, 'Bar'),
  ('Comment les performances exceptionnelles des employés sont-elles reconnues et récompensées dans votre entreprise ?', 9, 3, NULL, 'CM', 9, 'Bar'),
  
  -- Section 3: Cessation d'Emploi
  ( 'Quels sont les motifs les plus courants pour lesquels les employés quittent votre entreprise ?', 10, 3, NULL, 'CM', 10, 'Bar'),
  ( 'Menez-vous des entretiens de départ pour comprendre les raisons du départ des employés ?', 10, 3, NULL, 'CU', 11, 'Pie'),
  ( 'Comment utilisez-vous les informations recueillies lors des entretiens de départ ?', 10, 3, 35, 'CM', 12, 'Bar'),
  ( 'Quelles mesures avez-vous mises en place pour prévenir les départs volontaires ?', 10, 3, NULL, 'CM', 13, 'Bar'),
  ('Avez-vous un plan de succession en place pour assurer la continuité des activités en cas de départ d''un employé clé ?', 10, 3, NULL, 'CU', 14, 'Pie');

-- Insert question items referencing the correct question IDs
INSERT INTO solution_questionnaire_question_items 
  ( item, questionId, itemParentId, isOther) 
VALUES
  -- Items for Question 25
  ( 'Réseaux sociaux (LinkedIn, Facebook, etc.)', 25, NULL, 0),
  ( 'Sites de recrutement en ligne (LinkedIn, etc.)', 25, NULL, 0),
  ( 'Recommandations internes', 25, NULL, 0),
  ( 'Cabinets de recrutement externes', 25, NULL, 0),
  ('Foires et événements de recrutement', 25, NULL, 0),
  ( 'Partenariats avec universités/écoles', 25, NULL, 0),
  ( 'Autre (précisez)', 25, NULL, 1),
  
  -- Items for Question 26
  ( 'Culture d''entreprise (valeurs, mission, vision)', 26, NULL, 0),
  ( 'Opportunités de développement de carrière', 26, NULL, 0),
  ( 'Rémunération compétitive et avantages sociaux', 26, NULL, 0),
  ( 'Flexibilité du travail (télétravail, horaires flexibles)', 26, NULL, 0),
  ('Réputation et image de marque de l''entreprise', 26, NULL, 0),
  ( 'Innovation et technologies utilisées', 26, NULL, 0),
  ('Autre (précisez)', 26, NULL, 1),
  
  -- Items for Question 27
  ('Programmes d''intégration formels', 27, NULL, 0),
  ('Parrainage ou mentorat', 27, NULL, 0),
  ( 'Sessions de formation initiale', 27, NULL, 0),
  ( 'Réunions d''accueil avec la direction', 27, NULL, 0),
  ('Autre (précisez)', 27, NULL, 1),
  
  -- Items for Question 28
  ( 'Participation à des classements d''employeurs', 28, NULL, 0),
  ( 'Programme d''ambassadeurs internes', 28, NULL, 0),
  ('Campagnes de communication sur les réseaux sociaux', 28, NULL, 0),
  ('Témoignages de salariés', 28, NULL, 0),
  ('Autre (précisez)', 28, NULL, 1),
  
  -- Items for Question 29
  ('Reconnaissance et récompenses', 29, NULL, 0),
  ( 'Possibilités d''évolution de carrière', 29, NULL, 0),
  ('Culture de travail positive', 29, NULL, 0),
  ('Avantages sociaux', 29, NULL, 0),
  ('Équilibre travail-vie privée', 29, NULL, 0),
  ('Leadership et gestion de la direction', 29, NULL, 0),
  ('Autre (précisez)', 29, NULL, 1),
  
  -- Items for Question 30
  ('Plans de carrière personnalisés', 30, NULL, 0),
  ('Augmentations salariales basées sur la performance', 30, NULL, 0),
  ( 'Plans de stock-options ou participation', 30, NULL, 0),
  ( 'Programmes de mentorat et de développement', 30, NULL, 0),
  ('Programmes de bien-être', 30, NULL, 0),
  ( 'Avantages flexibles', 30, NULL, 0),
  ( 'Autre (précisez)', 30, NULL, 1),
  
  -- Items for Question 31
  ('Oui', 31, NULL, 0),
  ('Non', 31, NULL, 0),
  
  -- Items for Question 32
  ('Trimestriellement', 32, 140, 0),
  ('Semestriellement', 32, 140, 0),
  ( 'Annuellement', 32, 140, 0),
  ('Autre (précisez)', 32, 140, 1),
  
  -- Items for Question 33
  ('Récompenses monétaires', 33, NULL, 0),
  ('Reconnaissance publique', 33, NULL, 0),
  ('Opportunités de formation ou développement', 33, NULL, 0),
  ('Promotions et mobilité interne', 33, NULL, 0),
  ('Autre (précisez)', 33, NULL, 1),
  
  -- Items for Question 34
  ('Meilleure opportunité ailleurs', 34, NULL, 0),
  ('Insatisfaction salariale', 34, NULL, 0),
  ( 'Manque de progression de carrière', 34, NULL, 0),
  ('Conflits internes', 34, NULL, 0),
  ( 'Épuisement professionnel ou stress', 34, NULL, 0),
  ( 'Recherche d''un meilleur équilibre travail-vie privée', 34, NULL, 0),
  ( 'Autre (précisez)', 34, NULL, 1),
  
  -- Items for Question 35
  ('Oui, systématiquement', 35, NULL, 0),
  ('Oui, mais pas pour tous les départs', 35, NULL, 0),
  ('Non, pas de manière formelle', 35, NULL, 0),
  
  -- Items for Question 36
  ( 'Pour ajuster les pratiques RH', 36, 158, 0),
  ( 'Pour revoir les politiques de gestion des talents', 36, 158, 0),
  ( 'Pour améliorer les conditions de travail', 36, 158, 0),
  ('Pour informer les stratégies de rétention futures', 36, 158, 0),
  ('Autre (précisez)', 36, 158, 1),
  
  -- Items for Question 37
  ( 'Augmentations salariales basées sur la performance', 37, NULL, 0),
  ('Amélioration des conditions de travail', 37, NULL, 0),
  ( 'Programmes de bien-être', 37, NULL, 0),
  ('Révisions régulières des politiques RH', 37, NULL, 0),
  ('Autre (précisez)', 37, NULL, 1),
  
  -- Items for Question 38
  ( 'Oui, pour tous les postes critiques', 38, NULL, 0),
  ( 'Oui, mais seulement pour certains postes', 38, NULL, 0),
  ('Non', 38, NULL, 0);