use salarymarket ;
-- initialise languages
INSERT INTO languages (id, language, tag) VALUES 
(1, 'English', 'en'),
(2, 'French', 'fr');
-- initialise language solution
INSERT INTO solution_languages (id, active, defaultLanguage, languagesId) VALUES 
(1, 'true', 0, '1'),
(2, 'true', 1, '2');
-- initialise menu solution
INSERT INTO solution_menu (id, menuCode, menuLibelle, parentMenu, menu_type, menu_position) VALUES
-- Home Section
(1, 'home', 'Home',NULL, 'menu',1),
(2, 'home_administration', 'Administration', 'home', 'subMenu',1),
(3, 'home_administration_clients', ' Number  of Clients ', 'home_administration', 'widget',1),
(4, 'home_administration_secteurs', ' Clients per Sector', 'home_administration', 'widget',1),
(5, 'home_administration_subscription', 'Subscription  per clients ', 'home_administration', 'widget',1), 
(6, 'home_administration_employees_per_region', 'Employees per Region', 'home_administration', 'widget',1),
(7, 'home_indicators', 'Indicators','home', 'subMenu',1),
(8, 'home_indicateurs_number_of_employees', 'Number of Employees', 'home_indicators', 'widget',1),
(9, 'home_indicateurs_employees_per_gender', 'Number of Employees by Gender', 'home_indicators', 'widget',1),
(10, 'home_indicateurs_payroll', 'Payroll','home_indicators', 'widget',1),
(11, 'home_indicateurs_median_salaries_by_career_path', 'Average Salaries by Career Path', 'home_indicators', 'widget',1),
(12, 'home_indicateurs_supervision_rate', 'Supervision Rate', 'home_indicators', 'widget',1),
(13, 'home_indicateurs_median_salaries_by_grade', 'Average Salaries by Grade', 'home_indicators', 'widget',1),
-- Compensation Section
(14, 'company_compensation', 'Company Compensation', NULL, 'menu',1),
-- Quiz Section
(15, 'company_quiz', 'HR Policy and Practices', NULL, 'menu',0),
(16, 'quiz_current_sector', 'Quiz current Sector','company_quiz', 'option',1),  
(17, 'quiz_market', 'Quiz by Market', 'company_quiz', 'option',1),
-- Report Section
(18, 'report', 'Report', NULL, 'menu',0),
-- My Company Section
(19, 'myCompany', 'My Company', NULL, 'menu',1),
(20, 'myCompany_informations', 'Information', 'myCompany', 'menu',1),
(21, 'myCompany_users', 'Users', 'myCompany', 'menu',1),
(22, 'myCompany_entities', 'Entities', 'myCompany', 'menu',1),
(23, 'myCompany_profiles', 'Profiles','myCompany', 'menu',1),
(24, 'myCompany_configuration', 'Configuration', 'myCompany', 'menu',1),
(25, 'myCompany_settings', 'Settings', 'myCompany', 'menu',1),
(26, 'myCompany_settings_language', 'Language', 'myCompany_settings', 'subMenu',1),
-- My Clients Section
(27, 'myClients', 'My Clients', NULL, 'menu',1),
(28, 'myClients_clients', 'Clients', 'myClients', 'menu',1),
(29, 'client_informations', 'Information','myClients_clients', 'subMenu',1),
(30, 'client_users', 'Users', 'myClients_clients', 'subMenu',1),
(31, 'client_entities', 'Entities', 'myClients_clients', 'subMenu',1),
(32, 'client_profiles', 'Profiles', 'myClients_clients', 'subMenu',1),
(33, 'client_configuration', 'Configuration', 'myClients_clients', 'subMenu',1),
(34, 'myClients_prospection', 'Prospecting', 'myClients', 'menu',1),
-- Administration Section
(35, 'administration', 'Administration', NULL, 'menu',1),
(36, 'administration_settings', 'Settings', 'administration', 'menu',1),
(37, 'administration_settings_language', 'Language', 'administration_settings', 'subMenu',1),
(38, 'administration_settings_country', 'Country', 'administration_settings', 'subMenu',1),
(39, 'administration_settings_business-sector', 'Business Sector', 'administration_settings', 'subMenu',1),
(40, 'administration_settings_turnover', 'Turnover', 'administration_settings', 'subMenu',1),
(41, 'administration_settings_geographic-extent', 'Geographic Extent', 'administration_settings', 'subMenu',1),
(42, 'administration_settings_company-size', 'Company Size', 'administration_settings', 'subMenu',1),
(43, 'administration_settings_value-chain', 'Value Chain','administration_settings', 'subMenu',1),
(44, 'administration_entities', 'Entities', 'administration', 'menu',1),
(45, 'administration_subscription', 'Subscription', 'administration', 'menu',1);
-- initialise subscription solution
INSERT INTO solution_subscription (id,subscription_code,subscription_type) VALUES 
(1,'on_the_menu','On The Menu'),
(2,'essential','Essential'),
(3,'advanced','Advanced'),
(4, 'solution', 'Solution');
-- initialise rights for menus 
INSERT INTO solution_menu_rights (right_code, right_label, menuCode) VALUES
-- Compensation
('compensation_create', 'Create', 'company_compensation'),
('compensation_export', 'Export', 'company_compensation'),
('compensation_import', 'Import', 'company_compensation'),
('compensation_search', 'Search', 'company_compensation'),
('compensation_configuration', 'Configuration', 'company_compensation'),  -- NEW
('compensation_delete', 'Delete', 'company_compensation'),
('compensation_update', 'Update', 'company_compensation'),
('compensation_view' , 'View',   'company_compensation'),
-- HR Policy and Practices
('quiz_Submit', 'Submit', 'company_quiz'),
('quiz_View', 'View', 'company_quiz'),
-- Report 
('report_create', 'Create', 'report'),
('report_View', 'View', 'report'),
('report_delete', 'Delete', 'report'),
('report_upload', 'Upload', 'report'),
-- Informations company
('company_Informations_update', 'Update', 'myCompany_informations'),
-- Users company
('company_user_create', 'Create', 'myCompany_users'),
('company_user_update', 'Update', 'myCompany_users'),
('company_user_delete', 'Delete', 'myCompany_users'),
('company_user_desactivate', 'Desactivate', 'myCompany_users'),
('company_user_activity', 'Activity', 'myCompany_users'),
('company_user_view', 'View', 'myCompany_users'),
-- Entities company
('company_entity_create', 'Create', 'myCompany_entities'),
('company_entity_update', 'Update', 'myCompany_entities'),
('company_entity_delete', 'Delete', 'myCompany_entities'),
('company_entity_view', 'View', 'myCompany_entities'),
-- Profiles company
('company_profil_Create', 'Create', 'myCompany_profiles'),
('company_profil_view', 'View', 'myCompany_profiles'),
('company_profil_update', 'Update', 'myCompany_profiles'),
('company_profil_delete', 'Delete', 'myCompany_profiles'),
-- Languages company
('company_language_activate', 'Activate', 'myCompany_settings_language');

INSERT INTO solution_setting_country (id, code, active) VALUES
(1, 'TN', 1),
(2, 'FR', 1);

INSERT INTO solution_setting_country_translate (id, label, countryCode, languageId) VALUES
(1, 'Tunisia', 'TN', 1),   -- Traduction en anglais pour le pays TN
(2, 'Tunisie', 'TN', 2),   -- Traduction en français pour le pays TN
(3, 'France', 'FR', 1),    -- Traduction en anglais pour le pays FR
(4, 'France', 'FR', 2);    -- Traduction en français pour le pays FR

INSERT INTO solution_setting_sales_turnover (id, code) VALUES
(1, 'CA001'),
(2, 'CA002'),
(3, 'CA003'),
(4, 'CA004'),
(5, 'CA005');

INSERT INTO solution_setting_sales_turnover_translate (id, label, salesTurnoverCode, languageId) VALUES
(1, '1 - 10000', 'CA001', 1),    
(2, '1 - 10000', 'CA001', 2),   
(3, '10000 - 100000', 'CA002', 1),    
(4, '10000 - 100000', 'CA002', 2), 
(5, '100000 - 500000', 'CA003', 1),     
(6, '100000 - 500000', 'CA003', 2),
(7, '500000 - 1000000', 'CA004', 1),   
(8, '500000 - 1000000', 'CA004', 2), 
(9, 'Over 100,000', 'CA005', 1),   
(10, 'Plus de 100000', 'CA005', 2);  

INSERT INTO solution_setting_company_size (id, code) VALUES
(1, 'CS001'),
(2, 'CS002'),
(3, 'CS003'),
(4, 'CS004'),
(5, 'CS005'),
(6, 'CS006'),
(7, 'CS007'),
(8, 'CS008'),
(9, 'CS009'),
(10, 'CS0010');

INSERT INTO solution_setting_company_size_translate (id, label, companySizeCode, languageId) VALUES
(1, 'Less than 10', 'CS001', 1),    
(2, 'Moins de 10', 'CS001', 2),   
(3, 'Between 11 and 20', 'CS002', 1),    
(4, 'Entre 11 et 20', 'CS002', 2), 
(5, 'Between 21 and 30', 'CS003', 1),     
(6, 'Entre 21 et 30', 'CS003', 2),
(7, 'Between 31 and 50', 'CS004', 1),   
(8, 'Entre 31 et 50', 'CS004', 2), 
(9, 'Between 51 and 100', 'CS005', 1),   
(10, 'Entre 51 et 100', 'CS005', 2),  
(11, 'Between 101 and 300', 'CS006', 1),    
(12, 'Entre 101 et 300', 'CS006', 2),   
(13, 'Between 301 and 500', 'CS007', 1),    
(14, 'Entre 301 et 500', 'CS007', 2), 
(15, 'Between 501 and 1000', 'CS008', 1),     
(16, 'Entre 501 et 1000', 'CS008', 2),
(17, 'Between 1001 and 2000', 'CS009', 1),   
(18, 'Entre 1001 et 2000', 'CS009', 2), 
(19, 'Over 2001', 'CS0010', 1),   
(20, 'Plus de 2001', 'CS0010', 2);
 
INSERT INTO solution_setting_value_chain (id, code) VALUES
(1, 'VC001'),
(2, 'VC002');

INSERT INTO solution_setting_value_chain_translate (id, label, valueChainCode, languageId) VALUES
(1, 'Full control of the entire value chain', 'VC001', 1),    
(2, 'Contrôle total de toute la chaine de valeur', 'VC001', 2),   
(3, 'Partial control of the value chain', 'VC002', 1),    
(4, 'Contrôle partiel de la chaine de valeur', 'VC002', 2);

INSERT INTO solution_setting_geographic_extent (id, code) VALUES
(1, 'GE001'),
(2, 'GE002'),
(3, 'GE003'),
(4, 'GE004');

INSERT INTO solution_setting_geographic_extent_translate (id, label, geographicExtentCode, languageId) VALUES
(1, 'Present in one country', 'GE001', 1),    
(2, 'Présent sur un seul pays', 'GE001', 2),   
(3, 'Present in several countries of the same region', 'GE002', 1),    
(4, 'Présent sur plusieurs pays d’une même région', 'GE002', 2), 
(5, 'Present in several countries on two different continents', 'GE003', 1),     
(6, 'Présent sur plusieurs pays de deux continents différents', 'GE003', 2),
(7, 'Present on more than two continents', 'GE004', 1),   
(8, 'Présent sur plus de deux continents', 'GE004', 2);
INSERT INTO solution_entities (id,entity_code, state, entity_level, title, parentId) VALUES 
(1,'admin_Solution', false, '0', 'Admin solution', '0');