
use salarymarket;
CREATE TABLE company_compensation (
	id INT AUTO_INCREMENT PRIMARY KEY,
    
    country  varchar(255) NULL,
	city  varchar(255) NULL,
    
	site VARCHAR(1) NULL,
	matricule VARCHAR(255) NULL,
	department VARCHAR(255) NULL,
	`function` VARCHAR(255) NULL,
	internal_grade VARCHAR(255) NULL,
    
	gender VARCHAR(2) NULL,
	birthday  VARCHAR(255) NULL,
    hiring_date  VARCHAR(255) NULL,
	function_code VARCHAR(255) NULL, 
	subfunction_code VARCHAR(255) NULL, -- changed instead of discipline_code 
    
	collaborative_path VARCHAR(255) NULL, -- changed instead of level_career_path  
	grade INT NULL, -- changed instead of job_grade
	number_employees_supervised INT NULL,
	devise VARCHAR(10) NULL,
	gross_annual_salary Decimal(10,3),
    
	number_monthly_salary VARCHAR(255) NULL,
	type_overtime_pay VARCHAR(255) NULL,
	seniority_bonus Decimal(10,3) NULL, -- new
	schooling_allowance Decimal(10,3) NULL, -- new
	meal_allowance Decimal(10,3)  NULL,
    
	location_allowance Decimal(10,3)  NULL,
	transportation_allowance Decimal(10,3)  NULL,
	other_bonuses_awarded_last_year Decimal(10,3) NULL , -- changed instead of other_bonuses_awarded
	fixed_allowances Decimal(10,3),
	eligibility_performance_bonus VARCHAR(1) NULL,
    
	target_performance_bonus Decimal(3,3),
	total_amount_performance_bonus_awarded Decimal(10,3),
	eligibility_commissions VARCHAR(1) NULL,
	target_variable_sales_compensation Decimal(3,3) NULL ,
	total_amount_sales_bonus_awarded Decimal(10,3) NULL,
    
	total_amount_sales_commissions_awarded Decimal(10,3) NULL,
	car_benefit_eligibility VARCHAR(1) NULL,
	annual_cost_car_depreciation Decimal(10,3) NULL,
    car_allocation_eligibility varchar(1) NULL ,
	annual_cost_car_allocation Decimal(10,3) NULL ,
    
    job VARCHAR(255) NULL,
	companyId INT NULL,
	FOREIGN KEY (companyId) REFERENCES company(id) ON DELETE CASCADE ON UPDATE CASCADE
);
-- Create solution_compensation table
CREATE TABLE solution_compensation_informations (
   id INT AUTO_INCREMENT PRIMARY KEY,
    column_code VARCHAR(50) NOT NULL,
    column_label VARCHAR(255) NOT NULL,
    description TEXT,
    languageId INT NOT NULL,
    FOREIGN KEY (languageId) REFERENCES languages(id) ON DELETE CASCADE ON UPDATE CASCADE
);
INSERT INTO  solution_compensation_informations 
    (column_code, column_label, description, languageId) 
VALUES 
    ('pays', 'Pays', 'pays',2),
    ('ville', 'Ville', 'Code de la Région ou la Ville du bureau principal dont ils sont rattachés.',2),
    ('site', 'Affectation', 'L\'étendue géographique de la ou des fonctions sous la responsabilité du titulaire du poste (M: Multisite, S: un seul site).', 2),
    ('matricule', 'Matricule interne', 'Matricule qui identifie le titulaire au sein de votre entreprise. Ce code est spécifique à chaque titulaire.',2),   
    ('departement', 'Nom du département', 'Le nom du département dans lequel le titulaire exerce ses responsabilités.', 2),
    ('fonction', 'Titre de poste','Intitulé de la fonction actuelle dans l\'entreprise.',2),
	('niveau_interne', 'Grade/Niveau interne', 'Grade ou niveau actuel du titulaire dans votre entreprise.',2),
    ('genre', 'Genre', 'M: Male, F: Femelle.',2),
    ('date_naissance', 'Date de naissance', 'Date de naissance du titulaire.',2),
    ('date_embauche', "Date d'embauche", "Date d'embauche du titulaire.",2),
    ('code_fonction', 'Code de la fonction', "Le code du Domaine d'Activité du poste du titulaire, composé de trois lettres (par ex. HRH).",2),
    ('code_sous_fonction', 'Code de la Discipline', 'Le code de la Discipline correspondant au poste du titulaire, composé de trois chiffres (ex: 120).',2),
    ('chemin_collaborative', 'Chemin collaboratif ', 'Le niveau de Carrière correspondant au poste du titulaire (ex: M1).', 2),
    ('grade', 'Grade du poste', 'Le grade du poste du titulaire (ex: 10).',2),
    ('nombre_employes_supervises', 'Nombre de salariés supervisés', "Si la colonne 'point de carrière' contient 'M' et 'EX', cette valeur doit être différente de 0; si la colonne 'point de carrière' contient 'P', 'S', 'T', 'U' et 'W', cette valeur doit être égale à 0.", 2),
	('devise', 'Devise des éléments de rémunération', 'Devise dans laquelle sont exprimés les éléments de rémunération.',2),
    ('salaire_annuel_brut', 'Salaire annuel brut', 'Le salaire brut est la somme du salaire de base + les indemnités légales en équivalent temps plein avant toute déduction.',2),
    ('nombre_salaire_mensuel', 'Nombre de versements mensuels', 'Nombre de versements du salaire brut sur un an, y compris les mois supplémentaires de salaire fixe (13e/14e mois), en fonction de la réglementation et des pratiques de votre organisation.', 2),
    ('remuneration_heures_supplementaires', 'Type de rémunération des heures supplémentaires', 'La méthode de rémunération des heures supplémentaires: A - Salaire tout compris (pas de rémunération pour les heures supplémentaires), G - Garanti (éligible à la rémunération garantie des heures supplémentaires), I - Individuel (éligible à la rémunération des heures supplémentaires sur une base individuelle), N - Non éligible.',2),
    ('prime_anciennete', 'Prime d\'ancienneté', '',2),
    ('prime_scolarité', 'Prime de scolarité', 'Prime de scolarité',2),
    ('allocation_repas', 'Allocation repas', 'Valeur annuelle des tickets-repas ou des repas fournis au titulaire ou coût annuel payé par l organisation pour les déjeuners à la cantine.', 2),
    ('prime_logement', 'Prime de logement', 'Montant annuel payé séparément du Salaire Annuel Brut pour compenser un différentiel de coût de la vie ou des pressions sur le marché du travail dans une région particulière.', 2),
    ('prime_transport', 'Prime de transport', 'Montant annuel attribué au titre des frais de transport.',2),
    ('autres_primes', 'Autre primes versées au titre du dernier exercice', 'Autres primes (hors prime sur objectif) versées au titre du dernier exercice.', 2),
    ('indemnites_fixes_especes', 'Indemnités fixes', 'La valeur de toute autre indemnité fixe versée en espèces durant le cycle annuel en cours.', 2),
    ('eligibilite_bonus_performance', 'Eligibilité au bonus de performance', 'E: Éligible - veuillez compléter les colonnes relatives au montant du bonus de performance cible et réellement versé en pourcentage du salaire brut. N: Non éligible.',2),
    ('prime_performance_cible', 'Bonus de performance cible', "Le taux cible du bonus de performance à l'atteinte de 100% de l'objectif en pourcentage du salaire brut annuel.", 2),
    ('montant_prime_performance', 'Montant total du bonus de performance', "Le montant total du bonus de performance attribué au titre du dernier exercice fiscal. Pour les bonus qui impliquent plusieurs versements au cours d'une année, il s'agira du montant annuel total.", 2),
    ('commissions_eligibilite', 'Eligibilité aux commissions', 'E: Éligible - veuillez compléter les colonnes relatives au montant des commissions en pourcentage. N: Non éligible.',2),
    ('remuneration_variable_commerciale', 'Rémunération variable commerciale cible', 'Le taux cible de la rémunération variable commerciale en pourcentage du salaire annuel brut.',  2),
    ('montant_total_primes_ventes', 'Montant total des primes de ventes attribuées', 'Le montant des primes de ventes perçues au titre du dernier exercice fiscal.', 2),
    ('montant_total_commissions_ventes', 'Montant total des commissions de vente', 'Le montant des commissions perçues au titre du dernier exercice fiscal.',2),
    ('eligibilite_avantage_voiture', "Critères d'éligibilité à l'avantage voiture", "Les critères pour bénéficier d'un avantage voiture: S - Éligibilité en fonction du statut de l'emploi, N - Éligibilité en fonction de la nature de l'emploi/des exigences du poste.", 2),
    ('amortissement_voiture', 'Amortissement voiture', "Oui : si le collaborateur bénéficie d'un amortissement voiture contre l'utilisation de sa voiture personnelle. Non : Si non concerné.",2 ),
    ('frais_annuel_amortissement_avantage_voiture', 'Frais annuel amortissement voiture', "La valeur annuelle allouée au titulaire du poste pour l'utilisation de sa voiture personnelle.", 2),
	('eligibilite_allocation_voiture', 'Eligibilite allocation voiture', "Éligibilité à l’attribution de voiture', 'Indique si un individu ou un employé est éligible à l’attribution d’une voiture selon des critères prédéfinis",2 ),
    ('frais_annuel_allocation_voiture', 'Frais annuel allocation voiture', "Coût annuel de l’attribution de voiture', 'Représente le coût annuel total associé à l’attribution d’une voiture, y compris l’entretien, l’assurance et autres dépenses connexes", 2);
   INSERT INTO  solution_compensation_informations 
    (column_code, column_label, description, languageId) 
     VALUES
	 ('country', 'Country', 'country',1),
    ('city', 'City', 'Code of the Region or the main office city they are attached to.', 1),
    ('site', 'Assignment', 'The geographical scope of the role responsibilities\n(M: Multisite, S: single site).', 1),
    ('matricule', 'Internal ID', 'ID that identifies the individual within your company. This code is specific to each employee.', 1),   
    ('department', 'Department Name', 'The name of the department in which the employee works.', 1),
    ('function', 'Job Title','Current job title in the company.', 1),
    ('internal_grade', 'Internal Grade/Level', 'Current grade or level of the employee in your company.', 1),
    ('gender', 'Gender', 'M: Male, F: Female.', 1),
    ('birthday', 'Date of Birth', 'Employee\'s date of birth.', 1),
    ('hiring_date', "Hiring Date", "Employee's hiring date.", 1),
    ('function_code', 'Job Function Code', "The code of the job's activity domain, consisting of three letters (e.g., HRH).", 1),
    ('subfunction_code', 'Discipline Code', 'The code of the discipline related to the job, consisting of three digits (e.g., 120).', 1),
    ('collaborative_path', 'Collaborative Path', 'The career level corresponding to the position (e.g., M1).', 1),
    ('grade', 'Job Grade', 'The grade of the employee\'s position (e.g., 10).', 1),
    ('number_employees_supervised', 'Number of Employees Supervised', "If the 'career point' column contains 'M' and 'EX', this value must be different from 0; if it contains 'P', 'S', 'T', 'U', and 'W', this value must be 0.", 1),
    ('devise', 'Currency of Pay Elements', 'Currency in which pay elements are expressed.', 1),
    ('gross_annual_salary', 'Gross Annual Salary', 'The gross salary is the sum of base salary + legal allowances in full-time equivalent before any deduction.', 1),
    ('number_monthly_salary', 'Number of Monthly Payments', 'Number of payments of the gross annual salary over a year, including extra months of fixed salary (13th/14th month), as per regulation and company practices.', 1),
    ('type_overtime_pay', 'Overtime Pay Type', 'The overtime pay method: A - All-inclusive salary (no overtime pay), G - Guaranteed (eligible for guaranteed overtime pay), I - Individual (eligible for individual overtime pay), N - Not eligible.', 1),
    ('seniority_bonus', 'Seniority Bonus', '', 1),
    ('schooling_allowance', 'Schooling Allowance', 'Schooling allowance.', 1),
    ('meal_allowance', 'Meal Allowance', 'Annual value of meal tickets or meals provided to the employee or annual cost paid by the organization for canteen meals.', 1),
    ('location_allowance', 'Housing Allowance', 'Annual amount paid separately from Gross Annual Salary to compensate for living cost differences or labor market pressures in a specific region.', 1),
    ('transportation_allowance', 'Transportation Allowance', 'Annual amount allocated for transportation expenses.', 1),
    ('other_bonuses_awarded_last_year', 'Other Bonuses Awarded Last Year', 'Other bonuses (excluding target bonuses) awarded last year.', 1),
    ('fixed_allowances', 'Fixed Allowances', 'The value of any other fixed allowance paid in cash during the current annual cycle.', 1),
    ('eligibility_performance_bonus', 'Performance Bonus Eligibility', 'E: Eligible - please complete columns related to target and actual bonus amounts as a percentage of gross salary. N: Not eligible.', 1),
    ('target_performance_bonus', 'Target Performance Bonus', "The target rate for performance bonuses upon achieving 100% of the objective, as a percentage of gross annual salary.", 1),
    ('total_amount_performance_bonus_awarded', 'Total Performance Bonus Amount', "The total performance bonus amount awarded last fiscal year. For bonuses involving multiple payments over a year, this is the total annual amount.", 1),
    ('eligibility_commissions', 'Commissions Eligibility', 'E: Eligible - please complete columns related to commission amounts as a percentage. N: Not eligible.', 1),
    ('target_variable_sales_compensation', 'Target Variable Sales Compensation', 'The target rate of variable sales compensation as a percentage of gross annual salary.', 1),
    ('total_amount_sales_bonus_awarded', 'Total Sales Bonus Amount', 'The amount of sales bonuses received last fiscal year.', 1),
    ('total_amount_sales_commissions_awarded', 'Total Sales Commissions Amount', 'The amount of sales commissions received last fiscal year.', 1),
    ('car_benefit_eligibility', 'Car Benefit Eligibility', "Criteria for car benefits: S - Eligibility based on job status, N - Eligibility based on job requirements.", 1),
    ('car_depreciation', 'Car Depreciation', "Yes: if the employee benefits from car depreciation for using their personal car. No: if not applicable.", 1),
    ('annual_cost_car_depreciation', 'Annual Car Depreciation Cost', "Annual value allocated to the employee for using their personal car.", 1),
	('car_allocation_eligibility', 'Car allocation eligibility', 'Indicates whether an individual or employee is eligible for car allocation based on predefined criteria.', 1),
	('annual_cost_car_allocation', 'Annual cost car allocation', 'Represents the total annual cost associated with the allocation of a car, including maintenance, insurance, and other related expenses.', 1);