use socle;
-- Quiz 4 – Company Vehicles (“Véhicules de Société”)
-- 1) solution_quiz
INSERT INTO solution_quiz (id, quizCode, quiz_image, averagetime)
VALUES
  (4,
   'quiz_4_Company_Vehicles',
   'Questionnaire 4 -Vehicules de Société.jpg',
   10);
-- 2) solution_quiz_translate (French & English)
INSERT INTO solution_quiz_translate (quizCode, title, description, short_description, languageId)
VALUES
  -- French
  ('quiz_4_Company_Vehicles',
   'Questionnaire 4 - les Véhicules de Société',
   'Ce questionnaire couvre la politique de l’entreprise en matière de véhicules de fonction et de service : attribution, financement, maintenance, carburant et assurances.',
   'Politiques et pratiques des véhicules de société',
   2),
  -- English
  ('quiz_4_Company_Vehicles',
   'Quiz 4 – Company Vehicles',
   'This quiz examines corporate car and service-vehicle policies : allocation criteria, financing, maintenance, fuel coverage, and insurance.',
   'Company vehicles policies & practices',
   1);
-- 3) solution_quiz_section
INSERT INTO solution_quiz_section (sectionCode, quizCode, section_order)
VALUES
  ('executive_vehicles', 'quiz_4_Company_Vehicles', 1),
  ('service_vehicles',   'quiz_4_Company_Vehicles', 2);
-- 4) solution_quiz_section_translate (French & English)
INSERT INTO solution_quiz_section_translate (sectionCode, title, languageId)
VALUES
  -- English titles
  ('executive_vehicles', 'Executive Vehicles', 1),
  ('service_vehicles',   'Service Vehicles',   1),
  -- French titles
  ('executive_vehicles', 'Voitures de fonction', 2),
  ('service_vehicles',   'Voitures de service',  2);
-- 5) solution_quiz_section_questions
-- Section 1: executive_vehicles
INSERT INTO solution_quiz_section_questions (questionCode, sectionCode, quizCode, idparent, type, question_order, echartType)
VALUES
  ('Q4-VF-1',  'executive_vehicles', 'quiz_4_Company_Vehicles', NULL,      'CU', 1,  'Pie'),
  ('Q4-VF-2',  'executive_vehicles', 'quiz_4_Company_Vehicles', 'Q4-VF-1', 'CU', 2,  'Pie'),
  ('Q4-VF-3',  'executive_vehicles', 'quiz_4_Company_Vehicles', 'Q4-VF-2', 'CM', 3,  'Bar'),
  ('Q4-VF-4',  'executive_vehicles', 'quiz_4_Company_Vehicles', 'Q4-VF-1', 'CU', 4,  'Pie'),
  ('Q4-VF-5',  'executive_vehicles', 'quiz_4_Company_Vehicles', 'Q4-VF-1', 'CM', 5,  'tab_num'),
  ('Q4-VF-6',  'executive_vehicles', 'quiz_4_Company_Vehicles', 'Q4-VF-1', 'CM', 6,  'Bar'),
  ('Q4-VF-7',  'executive_vehicles', 'quiz_4_Company_Vehicles',  NULL, 'CU', 7,  'Pie'),
  ('Q4-VF-8',  'executive_vehicles', 'quiz_4_Company_Vehicles', 'Q4-VF-1', 'CU', 8,  'Pie'),
  ('Q4-VF-9',  'executive_vehicles', 'quiz_4_Company_Vehicles', 'Q4-VF-1', 'CU', 9,  'Pie'),
  ('Q4-VF-10', 'executive_vehicles', 'quiz_4_Company_Vehicles', 'Q4-VF-1', 'CU', 10, 'Pie');
-- Section 2: service_vehicles
INSERT INTO solution_quiz_section_questions (questionCode, sectionCode, quizCode, idparent, type, question_order, echartType)
VALUES
  ('Q4-VS-1',  'service_vehicles', 'quiz_4_Company_Vehicles', NULL,'CU',      11,  'Pie'),
  ('Q4-VS-2',  'service_vehicles', 'quiz_4_Company_Vehicles', 'Q4-VS-1','CU', 12,  'Pie'),
  ('Q4-VS-3',  'service_vehicles', 'quiz_4_Company_Vehicles', 'Q4-VS-1','CM', 13,  'Bar'),
  ('Q4-VS-4',  'service_vehicles', 'quiz_4_Company_Vehicles', 'Q4-VS-1','CM', 14,  'Bar'),
  ('Q4-VS-5',  'service_vehicles', 'quiz_4_Company_Vehicles', 'Q4-VS-1','CM', 15,  'Bar'),
  ('Q4-VS-6',  'service_vehicles', 'quiz_4_Company_Vehicles', 'Q4-VS-1','CU', 16,  'Pie'),
  ('Q4-VS-7',  'service_vehicles', 'quiz_4_Company_Vehicles', 'Q4-VS-1','CU', 17,  'Bar'),
  ('Q4-VS-8',  'service_vehicles', 'quiz_4_Company_Vehicles', 'Q4-VS-1','CU', 18,  'Pie'),
  ('Q4-VS-9',  'service_vehicles', 'quiz_4_Company_Vehicles', 'Q4-VS-1','CU', 19,  'Pie'),
  ('Q4-VS-10', 'service_vehicles', 'quiz_4_Company_Vehicles', 'Q4-VS-1','CU',  20,  'Pie');
-- 6) solution_quiz_section_questions_translate
-- Section 1: Executive Vehicles
INSERT INTO solution_quiz_section_questions_translate (questionCode, title, languageId)
VALUES
  -- English
  ('Q4-VF-1',  'Does your company offer company cars to employees?',             1),
  ('Q4-VF-2',  'Do you have a written policy for the use of company cars?',      1),
  ('Q4-VF-3',  'If yes, to which hierarchical levels are company cars mainly assigned?', 1),
  ('Q4-VF-4',  'Are company cars also offered to new employees?',                1),
  ('Q4-VF-5',  'What is the allocated budget for company cars? (specify by level)', 1),
  ('Q4-VF-6',  'What is the financing method for company cars?',                1),
  ('Q4-VF-7',  'Are fuel costs covered by the company?',                        1),
  ('Q4-VF-8',  'What is your insurance policy for company cars?',               1),
  ('Q4-VF-9',  'Are maintenance services included for company cars?',           1),
  ('Q4-VF-10', 'Are repair services included for company cars?',                1),
  -- French
  ('Q4-VF-1',  'Votre entreprise offre-t-elle des véhicules de fonction à ses employés ?',         2),
  ('Q4-VF-2',  'Disposez-vous d''une politique écrite concernant l''utilisation des voitures de fonction ?', 2),
  ('Q4-VF-3',  'À quels niveaux hiérarchiques les véhicules sont-ils principalement attribués ?', 2),
  ('Q4-VF-4',  'Les véhicules de fonction sont-ils également proposés aux nouveaux employés ?',   2),
  ('Q4-VF-5',  ' Quel est le budget alloué aux voitures attribués ?',       2),
  ('Q4-VF-6',  'Quel est le mode de financement des voitures de fonction ?',                    2),
  ('Q4-VF-7',  'Les frais de carburant sont-ils couverts par l''entreprise ?',                   2),
  ('Q4-VF-8',  'Quelle est votre politique en matière d’assurance pour les voitures de fonction ?',         2),
  ('Q4-VF-9',  'Des services d''entretien  sont-ils inclus pour les véhicules de fonction ?',     2),
  ('Q4-VF-10', 'Des services de réparation sont-ils inclus pour les véhicules de fonction ?',    2);
-- Section 2: Service Vehicles
INSERT INTO solution_quiz_section_questions_translate (questionCode, title, languageId)
VALUES
  -- English
  ('Q4-VS-1',  'Does your company offer service vehicles to employees?',               1),
  ('Q4-VS-2',  'Do you have a policy regarding service vehicle use?',                 1),
  ('Q4-VS-3',  'What is the financing method for service vehicles?',                 1),
  ('Q4-VS-4',  'What are the criteria for allocating service vehicles?',             1),
  ('Q4-VS-5',  'What types of vehicles do you offer as service vehicles?',           1),
  ('Q4-VS-6',  'Is personal use of service vehicles permitted?',                     1),
  ('Q4-VS-7',  'How do you manage maintenance and servicing of service vehicles?',   1),
  ('Q4-VS-8',  'How do you manage fuel costs for service vehicles?',                 1),
  ('Q4-VS-9',  'Do you track mileage for each vehicle?',                            1),
  ('Q4-VS-10','How frequently do you replace service vehicles?',                     1),
  -- French
  ('Q4-VS-1',  'Votre entreprise offre-t-elle des véhicules de service à ses employés ?',     2),
  ('Q4-VS-2',  'Disposez-vous d''une politique concernant l''utilisation des voitures de service ?', 2),
  ('Q4-VS-3',  'Quel est le mode de financement des voitures de service ?',                 2),
  ('Q4-VS-4',  'Quels sont les critères d''attribution des voitures de service ?',         2),
  ('Q4-VS-5',  'Quels types de véhicules proposez-vous en tant que voitures de service ?', 2),
  ('Q4-VS-6',  'L''utilisation personnelle des voitures de service est-elle autorisée ?',    2),
  ('Q4-VS-7',  'Comment gérez-vous la maintenance et l''entretien des voitures de service ?', 2),
  ('Q4-VS-8',  'Comment gérez-vous les coûts de carburant pour les voitures de service ?',   2),
  ('Q4-VS-9',  'Effectuez-vous un suivi du kilométrage pour chaque véhicule ?',              2),
  ('Q4-VS-10','À quelle fréquence remplacez-vous les voitures de service ?',                2);
-- 7) NEW response items
INSERT INTO solution_reponses_items (itemCode, itemName)
VALUES
  -- hierarchy levels
  ('yes_partially','yes partially'),
  ('middle_managers', 'Middle Managers & Experts professionnels'),
  ('support_tech', 'Support Technique'),
  ('support_professional',  'Support Professionnel'),
  -- VF-2 policy formality
  ('yes_formalized',  'Oui, formalisée'),
  ('yes_informal',  'Oui, mais informelle'),
    ('with-conditions', 'With conditions (specify)'),
  -- VF-6 / VS-3 financing modes
  ('cash_purchase',  'Achat au comptant par l''organisation'),
  ('leasing_no_maint', 'Contrat de location/leasing opérationnel sans entretien'),
  ('leasing_with_maint','Contrat de location/leasing opérationnel avec entretien'),
  ('credit_bail','Crédit-bail'),
  ('purchase_bonus', 'Prime à l''achat d''une voiture'),
  -- VF-7 fuel full
  ('yes_full', 'Oui, en totalité'),
  -- VF-8 insurance
  ('full_company','Couverture complète fournie par l’entreprise'),
  ('shared_user','Assurance partagée avec l’utilisateur'),
  ('full_user', 'Couverture complète fournie par l’utilisateur'),
  -- VS-2 policy formality
  ('yes_formal_comm',       'Oui, formalisée et communiquée à tous'),
  -- VS-4 criteria
  ('hierarchy_level',       'Niveau hiérarchique'),
  ('specific_function',     'Fonction spécifique (ex : commerciaux)'),
  ('operational_needs',     'Besoins opérationnels'),
  -- VS-5 vehicle types
  ('sedan',    'Berline'),
  ('van' ,'Camionnette/utilitaire'),
  -- VS-6 personal use
  ('yes_unrestricted', 'Oui, sans restriction'),
  ('yes_limited',   'Oui, mais avec des limites (ex : kilométrage)'),
('no_unique_for_activity_prof',   'No, only for professional activities'),

  
  -- VS-7 maintenance
  ('contracted_maintenance','Contrats d’entretien avec un prestataire'),
  ('internal_management',  'Gestion en interne'),
  ('user_responsibility',  'Responsabilité de l’utilisateur'),
  -- VS-8 fuel handling
  ('fuel_card',  'Carte carburant fournie par l’entreprise'),
  ('reimbursement',  'Remboursement sur justificatifs'),
  ('monthly_allowance',     'Forfait mensuel'),
  -- VS-9 mileage tracking
  ('yes_auto', 'Oui, via un système automatisé'),
  ('yes_manual',   'Oui, rapport manuel de l’utilisateur'),
  -- VS-10 replacement frequency
  ('under_3',  'Moins de 3 ans'),
  ('3_5',  '3 à 5 ans'),
  ('over_5', 'Plus de 5 ans'),
  ('no_policy',  'Pas de politique définie');
-- 8) Link items to questions
INSERT INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther)
VALUES
  -- Q4-VF-1
  ('yes',  'Q4-VF-1', NULL, 0),
  ('no', 'Q4-VF-1', NULL, 0),
  -- Q4-VF-2
  ('yes_formalized', 'Q4-VF-2', 'yes', 0),
  ('yes_informal',   'Q4-VF-2', 'yes', 0),
  ('no',  'Q4-VF-2', 'yes', 0),
  
  -- Q4-VF-3 (levels)
  ('executives',  'Q4-VF-3', 'yes_formalized', 0),
  ('middle_managers', 'Q4-VF-3', 'yes_formalized', 0),
  ('managers', 'Q4-VF-3', 'yes_formalized', 0),
  ('sales','Q4-VF-3', 'yes_formalized', 0),
  ('professionals', 'Q4-VF-3', 'yes_formalized', 0),
  ('support_tech', 'Q4-VF-3', 'yes_formalized', 0),
  ('support_professional', 'Q4-VF-3', 'yes_formalized', 0),
  
  -- Q4-VF-3 (yes_informal)
  ('executives',  'Q4-VF-3', 'yes_informal', 0),
  ('middle_managers', 'Q4-VF-3', 'yes_informal', 0),
  ('managers', 'Q4-VF-3', 'yes_informal', 0),
  ('sales','Q4-VF-3', 'yes_informal', 0),
  ('professionals', 'Q4-VF-3', 'yes_informal', 0),
  ('support_tech', 'Q4-VF-3', 'yes_informal', 0),
  ('support_professional', 'Q4-VF-3', 'yes_informal', 0),
  
  -- Q4-VF-4
  ('yes',  'Q4-VF-4', 'yes', 0),
  ('no', 'Q4-VF-4', 'yes', 0),
  ('with-conditions', 'Q4-VF-4', 'yes', 1),
  -- Q4-VF-5 
  ('executives',  'Q4-VF-5', 'yes', 1),
  ('middle_managers',  'Q4-VF-5', 'yes', 1),
  ('managers', 'Q4-VF-5', 'yes', 1),
  ('sales',  'Q4-VF-5', 'yes', 1),
  ('professionals', 'Q4-VF-5', 'yes', 1),
  ('support_tech', 'Q4-VF-5', 'yes', 1),
  ('support_professional', 'Q4-VF-5', 'yes', 1),
  -- Q4-VF-6
  ('cash_purchase',  'Q4-VF-6', 'yes', 0),
  ('leasing_no_maint', 'Q4-VF-6','yes', 0),
  ('leasing_with_maint',  'Q4-VF-6', 'yes', 0),
  ('credit_bail', 'Q4-VF-6', 'yes', 0),
  ('purchase_bonus',  'Q4-VF-6', 'yes', 0),
  -- Q4-VF-7
  ('yes_full',  'Q4-VF-7', 'yes', 0),
  ('yes_partially', 'Q4-VF-7', 'yes', 0),
  ('no',  'Q4-VF-7', 'yes', 0),
  -- Q4-VF-8
  ('full_company', 'Q4-VF-8', 'yes', 0),
  ('shared_user','Q4-VF-8', 'yes', 0),
  ('full_user', 'Q4-VF-8', 'yes', 0),
  -- Q4-VF-9 & Q4-VF-10
  ('yes', 'Q4-VF-9',  'yes', 0),
  ('no',  'Q4-VF-9',  'yes', 0),
  
  ('yes', 'Q4-VF-10', 'yes', 0),
  ('no',  'Q4-VF-10', 'yes', 0),
  -- Q4-VS-1
  ('yes', 'Q4-VS-1', null, 0),
  ('no',  'Q4-VS-1', null, 0),
  -- Q4-VS-2
  ('yes_formal_comm','Q4-VS-2', 'yes', 0),
  ('yes_informal', 'Q4-VS-2', 'yes', 0),
  ('no',  'Q4-VS-2', 'yes', 0),
  -- Q4-VS-3 
  ('cash_purchase', 'Q4-VS-3', 'yes', 0),
  ('leasing_no_maint', 'Q4-VS-3', 'yes', 0),
  ('leasing_with_maint','Q4-VS-3', 'yes', 0),
  ('credit_bail',  'Q4-VS-3', 'yes', 0),
  -- Q4-VS-4
  ('hierarchy_level', 'Q4-VS-4', 'yes', 0),
  ('specific_function', 'Q4-VS-4', 'yes', 0),
  ('operational_needs',  'Q4-VS-4', 'yes', 0),
  ('other-please-specify','Q4-VS-4', 'yes', 1),
  -- Q4-VS-5
  ('sedan',  'Q4-VS-5', 'yes', 0),
  ('van',  'Q4-VS-5', 'yes', 0),
  ('other-please-specify','Q4-VS-5', 'yes', 1),
  -- Q4-VS-6
  ('yes_unrestricted','Q4-VS-6', 'yes', 0),
  ('yes_limited', 'Q4-VS-6', 'yes', 0),
  ('no_unique_for_activity_prof', 'Q4-VS-6', 'yes', 0),
  -- Q4-VS-7
  ('contracted_maintenance','Q4-VS-7', 'yes', 0),
  ('internal_management', 'Q4-VS-7','yes', 0),
  ('user_responsibility', 'Q4-VS-7', 'yes', 0),
  ('other-please-specify','Q4-VS-7', 'yes', 1),
  -- Q4-VS-8
  ('fuel_card', 'Q4-VS-8', 'yes', 0),
  ('reimbursement','Q4-VS-8', 'yes', 0),
  ('monthly_allowance','Q4-VS-8', 'yes', 0),
  -- Q4-VS-9
  ('yes_auto', 'Q4-VS-9', 'yes', 0),
  ('yes_manual', 'Q4-VS-9', 'yes', 0),
  ('no','Q4-VS-9', 'yes', 0),
  -- Q4-VS-10
  ('under_3', 'Q4-VS-10', 'yes', 0),
  ('3_5', 'Q4-VS-10', 'yes', 0),
  ('over_5','Q4-VS-10', 'yes', 0),
  ('no_policy', 'Q4-VS-10', 'yes', 0);
-- 9) Translations for the NEW items
INSERT INTO solution_quiz_question_items_translate (itemCode, itemValue, languageId)
VALUES
  -- middle/support levels
  ('middle_managers', 'Middle Managers & Experts professionnels', 2),
  ('support_tech', 'Support Technique', 2),
  ('support_professional', 'Support Professionnel', 2),
  ('yes_partially','Oui, partiellement',2),
  -- VF-2
  ('yes_formalized', 'Oui, formalisée', 2),
  ('yes_informal', 'Oui, mais informelle', 2),
  ('no_unique_for_activity_prof','Non, uniquement pour les activités professionnelles',2),
  -- VF-6 / VS-3
  ('cash_purchase', 'Achat au comptant par l''organisation', 2),
  ('leasing_no_maint', 'Contrat de location/leasing opérationnel sans entretien', 2),
  ('leasing_with_maint', 'Contrat de location/leasing opérationnel avec entretien', 2),
  ('credit_bail', 'Crédit-bail', 2),
  ('purchase_bonus', 'Prime à l''achat d''une voiture (paiement par l''entreprise à 
  l''employé d''une somme forfaitaire égale à la valeur de la voiture ou d''un montant annuel égal au coût de paiement de la voiture)', 2),
  -- VF-7
  ('yes_full', 'Oui, en totalité', 2),
  -- VF-8
  ('full_company', 'Couverture complète fournie par l''entreprise', 2),
  ('shared_user', 'Assurance partagée avec l''utilisateur', 2),
  ('full_user', 'Couverture complète fournie par l''utilisateur', 2),
  -- VS-2
  ('yes_formal_comm', 'Oui, formalisée et communiquée à tous', 2),
  ('with-conditions', 'Sous conditions (préciser)', 2),
  -- VS-4
  ('hierarchy_level', 'Niveau hiérarchique', 2),
  ('specific_function', 'Fonction spécifique (ex : commerciaux)', 2),
  ('operational_needs', 'Besoins opérationnels', 2),
  -- VS-5
  ('sedan', 'Berline', 2),
  ('van', 'Camionnette/utilitaire', 2),
  -- VS-6
  ('yes_unrestricted', 'Oui, sans restriction', 2),
  ('yes_limited', 'Oui, mais avec des limites (ex : kilométrage)', 2),
  -- VS-7
  ('contracted_maintenance', 'Contrats d''entretien avec un prestataire', 2),
  ('internal_management', 'Gestion en interne', 2),
  ('user_responsibility', 'Responsabilité de l''utilisateur', 2),
  -- VS-8
  ('fuel_card', 'Carte carburant fournie par l''entreprise', 2),
  ('reimbursement', 'Remboursement sur justificatifs', 2),
  ('monthly_allowance', 'Forfait mensuel', 2),
  -- VS-9
  ('yes_auto', 'Oui, via un système automatisé', 2),
  ('yes_manual', 'Oui, rapport manuel de l''utilisateur', 2),
  -- VS-10
  ('under_3', 'Moins de 3 ans', 2),
  ('3_5', '3 à 5 ans', 2),
  ('over_5', 'Plus de 5 ans', 2),
  ('no_policy', 'Pas de politique définie', 2);
  
  
  INSERT INTO solution_quiz_question_items_translate (itemCode, itemValue, languageId)
VALUES
  -- hierarchy levels
  ('middle_managers', 'Middle Managers & Experts professionals', 1),
  ('support_tech','Support Technicians',   1),
  ('support_professional',  'Support Professionals', 1),
  -- VF-2 policy formality
  ('yes_formalized', 'Yes, formalized',1),
  ('yes_informal',  'Yes, but informal', 1),
 ('with-conditions', 'With conditions (specify)', 1),
  -- VF-6 / VS-3 financing modes
  ('cash_purchase', 'Cash purchase by the organization',   1),
  ('leasing_no_maint', 'Operational lease without maintenance', 1),
  ('leasing_with_maint', 'Operational lease with maintenance', 1),
  ('credit_bail',  'Finance lease', 1),
  ('purchase_bonus',  'Car purchase bonus (payment by the company to the employee of a lump sum equal to the value of the car or an 
  annual amount equal to the cost of paying for the car).',  1),
  -- VF-7 fuel full
  ('yes_full',  'Yes, fully covered',  1),
  -- VF-8 insurance
  ('full_company',   'Full coverage by company',  1),
  ('shared_user',  'Shared insurance with user', 1),
  ('full_user', 'Full coverage by user', 1),
  -- VS-2 policy formality
  ('yes_formal_comm','Yes, formalized and communicated to all',1),
  -- VS-4 criteria
  ('hierarchy_level', 'By hierarchical level', 1),
  ('specific_function','By specific function (e.g. sales)',1),
  ('operational_needs', 'By operational needs', 1),
  -- VS-5 vehicle types
  ('sedan',   'Sedan',   1),
  ('van', 'Van/Utility vehicle',1),
  -- VS-6 personal use
  ('yes_unrestricted',  'Yes, without restriction',  1),
  ('yes_limited','Yes, with limits (e.g. mileage)',  1),
  -- VS-7 maintenance
  ('contracted_maintenance','Contracted maintenance with provider',   1),
  ('internal_management',  'Managed internally',1),
  ('user_responsibility',  'User’s responsibility',  1),
  -- VS-8 fuel handling
  ('fuel_card',  'Company-issued fuel card', 1),
  ('reimbursement',  'Reimbursement upon receipt',  1),
  ('monthly_allowance', 'Monthly allowance',  1),
  -- VS-9 mileage tracking
  ('yes_auto',  'Yes, via automated system', 1),
  ('yes_manual','Yes, manual user report', 1),
  -- VS-10 replacement frequency
  ('under_3', 'Under 3 years',   1),
  ('3_5',  '3 to 5 years',   1),
  ('over_5', 'Over 5 years',   1),
 ('no_unique_for_activity_prof','No, only for professional activities',1),
   ('yes_partially','yes, partially',2),
  ('no_policy','No policy defined',  1);