use salarymarket;
-- 1) Quiz definition
INSERT INTO solution_quiz (id, quizCode, quiz_image, averagetime)
VALUES
  (10, 'quiz_10_Avantages_Annexes', 'Questionnaire 10 - Avantages et Annexes.jpg', 15);
-- 2) Quiz translations
INSERT INTO solution_quiz_translate (quizCode, title, description, short_description, languageId)
VALUES
  ('quiz_10_Avantages_Annexes',
   'Questionnaire 10 – Avantages et Annexes',
   'Étude des politiques et pratiques des avantages garantis, allocations et annexes',
   'Étude des avantages garantis, allocations et annexes',
   2),
  ('quiz_10_Avantages_Annexes',
   'Quiz 10 – Guaranteed Benefits, Allowances & Annexes',
   'Survey of guaranteed benefits, allowances, and annexes',
   'Survey of benefits, allowances & annexes',
   1);
-- 3) Sections
INSERT INTO solution_quiz_section (sectionCode, quizCode, section_order)
VALUES
  ('General_Policy', 'quiz_10_Avantages_Annexes', 1),
  ('Meal_Benefits', 'quiz_10_Avantages_Annexes', 2),
  ('Health_Insurance', 'quiz_10_Avantages_Annexes', 3),
  ('Retirement_Plan', 'quiz_10_Avantages_Annexes', 4),
  ('Professional_Equipment', 'quiz_10_Avantages_Annexes', 5),
  ('Cultural_Sports_Family', 'quiz_10_Avantages_Annexes', 6);
-- 4) Section translations
INSERT INTO solution_quiz_section_translate (sectionCode, title, languageId)
VALUES
  ('General_Policy', 'Politique Générale', 2),
  ('General_Policy', 'General Policy', 1),
  ('Meal_Benefits', 'Avantage Repas', 2),
  ('Meal_Benefits', 'Meal Benefits', 1),
  ('Health_Insurance', 'Assurance santé & vie', 2),
  ('Health_Insurance', 'Health & Life Insurance', 1),
  ('Retirement_Plan', 'Plan de retraite', 2),
  ('Retirement_Plan', 'Retirement Plan', 1),
  ('Professional_Equipment', 'Avantages en matériel professionnel', 2),
  ('Professional_Equipment', 'Professional Equipment Benefits', 1),
  ('Cultural_Sports_Family', 'Avantages culturels, sportifs et familiaux', 2),
  ('Cultural_Sports_Family', 'Cultural, Sports & Family Benefits', 1);
-- 5) Questions & chart types
INSERT INTO solution_quiz_section_questions
  (questionCode, sectionCode, quizCode, idparent, type, question_order, echartType)
VALUES
  -- General Policy
  ('Q10-GP-A', 'General_Policy', 'quiz_10_Avantages_Annexes', NULL, 'CU', 1, 'Pie'),
  ('Q10-GP-B', 'General_Policy', 'quiz_10_Avantages_Annexes', NULL, 'CM', 2, 'Bar'),
  -- Meal Benefits
  ('Q10-MB-1.1', 'Meal_Benefits', 'quiz_10_Avantages_Annexes', NULL, 'CM_all', 3, 'Table'),
  ('Q10-MB-1.2', 'Meal_Benefits', 'quiz_10_Avantages_Annexes', NULL, 'CM', 4, 'Pie'),
  ('Q10-MB-1.3', 'Meal_Benefits', 'quiz_10_Avantages_Annexes', 'Q10-MB-1.2', 'CU', 5, 'Table'),
  ('Q10-MB-1.4', 'Meal_Benefits', 'quiz_10_Avantages_Annexes', 'Q10-MB-1.2', 'CU', 6, 'Table'),
  ('Q10-MB-1.5', 'Meal_Benefits', 'quiz_10_Avantages_Annexes', NULL, 'CM', 7, 'Table'),
  -- Health & Life Insurance
  ('Q10-HI-2.1', 'Health_Insurance', 'quiz_10_Avantages_Annexes', NULL, 'CU', 8, 'Pie'),
  ('Q10-HI-2.2', 'Health_Insurance', 'quiz_10_Avantages_Annexes', 'Q10-HI-2.1', 'CU', 9, 'Table'),
  ('Q10-HI-2.3', 'Health_Insurance', 'quiz_10_Avantages_Annexes', NULL, 'CU', 10, 'Bar'),
  ('Q10-HI-2.4', 'Health_Insurance', 'quiz_10_Avantages_Annexes', NULL, 'CU', 11, 'Pie'),
  ('Q10-HI-2.5', 'Health_Insurance', 'quiz_10_Avantages_Annexes', 'Q10-HI-2.4', 'CM', 12, 'Table'),
  -- Retirement Plan
  ('Q10-RP-3.1', 'Retirement_Plan', 'quiz_10_Avantages_Annexes', NULL, 'CM', 13, 'Pie'),
  ('Q10-RP-3.2', 'Retirement_Plan', 'quiz_10_Avantages_Annexes', 'Q10-RP-3.1', 'CU', 14, 'Pie'),
  -- Professional Equipment
  ('Q10-PE-3.1', 'Professional_Equipment', 'quiz_10_Avantages_Annexes', NULL, 'CM', 15, 'Bar'),
  ('Q10-PE-3.2', 'Professional_Equipment', 'quiz_10_Avantages_Annexes', NULL, 'CU', 16, 'Pie'),
  -- Cultural, Sports & Family
  ('Q10-CSF-4.1', 'Cultural_Sports_Family', 'quiz_10_Avantages_Annexes', NULL, 'CU', 17, 'Table'),
  ('Q10-CSF-4.2', 'Cultural_Sports_Family', 'quiz_10_Avantages_Annexes', 'Q10-CSF-4.1', 'CM', 18, 'Pie'),
  ('Q10-CSF-4.3', 'Cultural_Sports_Family', 'quiz_10_Avantages_Annexes', 'Q10-CSF-4.1', 'CU', 18, 'Pie');

-- 6) Question translations (French & English)
INSERT INTO solution_quiz_section_questions_translate (questionCode, title, languageId)
VALUES
  -- General Policy
  ('Q10-GP-A', 'Disposez vous d\'une politique formelle pour les avantages ?', 2),
  ('Q10-GP-A', 'Do you have a formal policy for benefits?', 1),
  ('Q10-GP-B', 'Comment les collaborateurs sont-ils informés de leurs droits aux avantages ?', 2),
  ('Q10-GP-B', 'How are employees informed of their rights to benefits?', 1),
  -- Meal Benefits
  ('Q10-MB-1.1', 'Quelles catégories de personnel éligibles à l\'avantage repas?', 2),
  ('Q10-MB-1.1', 'Which personnel categories are eligible for meal benefits?', 1),
  ('Q10-MB-1.2', 'Quels types d\'avantages repas sont proposés ?', 2),
  ('Q10-MB-1.2', 'What types of meal benefits are offered?', 1),
  ('Q10-MB-1.3', 'Quelles est la valeur faciale unitaire des tickets restaurant ?', 2),
  ('Q10-MB-1.3', 'What is the unit face value of meal tickets?', 1),
  ('Q10-MB-1.4', 'Quel est le nombre de tickets servis mensuellement ?', 2),
  ('Q10-MB-1.4', 'How many meal tickets are served monthly?', 1),
  ('Q10-MB-1.5', 'Des équipements sont-ils mis à disposition pour la prise ou la préparation des repas sur site ?', 2),
  ('Q10-MB-1.5', 'Are facilities provided for on-site meal preparation or consumption?', 1),
  -- Health & Life Insurance
  ('Q10-HI-2.1', 'Votre entreprise propose-t-elle une couverture santé complémentaire ?', 2),
  ('Q10-HI-2.1', 'Does your company offer supplementary health coverage?', 1),
  ('Q10-HI-2.2', 'Quel est le niveau de prise en charge de la cotisation santé par l’employeur ?', 2),
  ('Q10-HI-2.2', 'What is the employer\'s share of health insurance contributions?', 1),
  ('Q10-HI-2.3', 'Quelle type d\'assurance proposez-vous ?', 2),
  ('Q10-HI-2.3', 'What type of insurance do you offer?', 1),
  ('Q10-HI-2.4', 'Proposez vous une Assurance vie ?', 2),
  ('Q10-HI-2.4', 'Do you offer life insurance?', 1),
  ('Q10-HI-2.5', 'Quelles catégories professionnelles bénéficient de l\'assurance vie?', 2),
  ('Q10-HI-2.5', 'Which professional categories benefit from life insurance?', 1),
  -- Retirement Plan
  ('Q10-RP-3.1', 'Disposez-vous d’un dispositif de retraite complémentaire ?', 2),
  ('Q10-RP-3.1', 'Do you have a supplementary retirement plan?', 1),
  ('Q10-RP-3.2', 'Votre entreprise prend t-elle en charge les frais de participation au dispositif de retraite complémentaire ?', 2),
  ('Q10-RP-3.2', 'Does your company cover the costs of participation in the supplementary retirement plan?', 1),
  -- Professional Equipment
  ('Q10-PE-3.1', 'Des équipements sont-ils mis à disposition individuelle pour l\'exécution du travail ?', 2),
  ('Q10-PE-3.1', 'Are individual equipment provided for work execution?', 1),
  ('Q10-PE-3.2', 'L’usage personnel de ces équipements est-il autorisé ?', 2),
  ('Q10-PE-3.2', 'Is personal use of this equipment allowed?', 1),
  -- Cultural, Sports & Family
  ('Q10-CSF-4.2', 'Quels types d’avantages annexes sont proposés à titre de bien-être ou de motivation ?', 2),
  ('Q10-CSF-4.2', 'What types of additional benefits are offered for well-being or motivation?', 1),
  ('Q10-CSF-4.3', 'Les avantages sont-ils accessibles à tous les salariés ?', 2),
  ('Q10-CSF-4.3', 'Are the benefits accessible to all employees?', 1),
  ('Q10-CSF-4.1', 'Votre société propose t''elle des avantages annexes à titres de bien-être ou de motivation?', 2),
  ('Q10-CSF-4.1', 'Does your company offer additional benefits for well-being or motivation?', 1);
-- 7) 
-- Only new items for Q10 
INSERT INTO solution_reponses_items (itemCode, itemName)
VALUES
('onboarding_contract', 'At hiring (HR booklet/contract)'),
('intranet_portal', 'Via HR intranet or employee portal'),
('manager_communication', 'By managerial communication'),
('no_formal_communication', 'No formal communication'),
('meal_voucher', 'Meal vouchers / Magnetic cards'),
('company_canteen', 'Company canteen/cafeteria'),
('other_meal_benefit', 'Other meal-related benefits (please specify)'),
('meal_3tnd', '3 TND'),
('meal_4tnd', '4 TND'),
('meal_5tnd', '5 TND'),
('meal_6tnd', '6 TND'),
('meal_7tnd', '7 TND'),
('meal_8tnd', '8 TND'),
('meal_10tnd', '10 TND'),
('meal_20', '20'),
('meal_22', '22'),
('meal_24', '24'),
('100_percent', '100%'),
('75_percent', '75%'),
('66_percent', '66%'),
('50_percent', '50%'),
('equipped_kitchen', 'Equipped kitchen or meal area'),
('microwave', 'Microwave'),
('refrigerator', 'Refrigerator'),
('coffee_machine', 'Coffee/tea machine'),
('snack_vending', 'Snack and drink vending machines'),
('no_equipment', 'No equipment'),
('mandatory_health', 'Yes, mandatory for all'),
('optional_health', 'Yes, optional'),
('health_insurance', 'Health insurance'),
('health_life_insurance', 'Health/life insurance'),
('health_life_disability', 'Health/Life/Disability insurance'),
('life_option', 'Optional for certain positions'),
('seniority_based', 'Based on seniority'),
('cavis_plan', 'Yes, supplementary retirement (CAVIS)'),
('individual_retirement', 'Yes, individual retirement plan'),
('variable_by_seniority', 'Variable by seniority or status'),
('work_phone', 'Work phone'),
('laptop', 'Laptop'),
('home_internet', 'Home internet/subscription'),
('no_equipment_assigned', 'No equipment assigned'),
('partial_use', 'Partially (restricted use)'),
('gym_membership', 'Gym membership'),
('cultural_activities', 'Participation in cultural activities (cinema, theater, museums)'),
('sports_team_building', 'Organization of sports or team building activities'),
('holiday_vouchers', 'Holiday vouchers'),
('childcare_services', 'Childcare support services'),
('school_fees', 'School fees coverage (dependent children)'),
('category_dependent', 'No, depends on job category'),
('seniority_dependent', 'No, depends on seniority');
-- French and English translations for new items
INSERT INTO solution_quiz_question_items_translate (itemCode, itemValue, languageId)
VALUES
('onboarding_contract', 'A l’embauche (livret RH / contrat)', 2), ('onboarding_contract', 'At hiring (HR booklet/contract)', 1),
('intranet_portal', 'Via l’intranet RH ou portail salariés', 2), ('intranet_portal', 'Via HR intranet or employee portal', 1),
('manager_communication', 'Par communication managériale', 2), ('manager_communication', 'By managerial communication', 1),
('no_formal_communication', 'Aucune communication formalisée', 2), ('no_formal_communication', 'No formal communication', 1),
('meal_voucher', 'Tickets restaurant / Cartes magnétiques', 2), ('meal_voucher', 'Meal vouchers / Magnetic cards', 1),
('company_canteen', 'Cantine ou cafétéria d\'entreprise', 2), ('company_canteen', 'Company canteen/cafeteria', 1),
('other_meal_benefit', 'Autres avantages liés au repas (veuillez préciser)', 2), ('other_meal_benefit', 'Other meal-related benefits (please specify)', 1),
('meal_3tnd', '3 TND', 2), ('meal_3tnd', '3 TND', 1),
('meal_4tnd', '4 TND', 2), ('meal_4tnd', '4 TND', 1),
('meal_5tnd', '5 TND', 2), ('meal_5tnd', '5 TND', 1),
('meal_6tnd', '6 TND', 2), ('meal_6tnd', '6 TND', 1),
('meal_7tnd', '7 TND', 2), ('meal_7tnd', '7 TND', 1),
('meal_8tnd', '8 TND', 2), ('meal_8tnd', '8 TND', 1),
('meal_10tnd', '10 TND', 2), ('meal_10tnd', '10 TND', 1),
('100_percent', '100%', 2), ('100_percent', '100%', 1),
('75_percent', '75%', 2), ('75_percent', '75%', 1),
('66_percent', '66%', 2), ('66_percent', '66%', 1),
('50_percent', '50%', 2), ('50_percent', '50%', 1),
('meal_20', '20', 2), ('meal_20', '20', 1),
('meal_22', '22', 2), ('meal_22', '22', 1),
('meal_24', '24', 2), ('meal_24', '24', 1),
('equipped_kitchen', 'Cuisine ou coin repas équipé', 2), ('equipped_kitchen', 'Equipped kitchen or meal area', 1),
('microwave', 'Micro-ondes', 2), ('microwave', 'Microwave', 1),
('refrigerator', 'Réfrigérateurs', 2), ('refrigerator', 'Refrigerator', 1),
('coffee_machine', 'Machine à café / thé', 2), ('coffee_machine', 'Coffee/tea machine', 1),
('snack_vending', 'Distributeurs automatiques de snacks et boissons', 2), ('snack_vending', 'Snack and drink vending machines', 1),
('no_equipment', 'Aucun équipement', 2), ('no_equipment', 'No equipment', 1),
('mandatory_health', 'Oui, obligatoire pour tous', 2), ('mandatory_health', 'Yes, mandatory for all', 1),
('optional_health', 'Oui, facultative', 2), ('optional_health', 'Yes, optional', 1),
('health_insurance', 'Assurance maladie', 2), ('health_insurance', 'Health insurance', 1),
('health_life_insurance', 'Assurance maladie/Décès', 2), ('health_life_insurance', 'Health/life insurance', 1),
('health_life_disability', 'Assurance Maladie/Décès/Invalidité', 2), ('health_life_disability', 'Health/Life/Disability insurance', 1),
('life_option', 'En option pour certains postes', 2), ('life_option', 'Optional for certain positions', 1),
('seniority_based', 'A partir d’un certain niveau d’ancienneté', 2), ('seniority_based', 'Based on seniority', 1),
('cavis_plan', 'Oui, retraite complémentaire (CAVIS)', 2), ('cavis_plan', 'Yes, supplementary retirement (CAVIS)', 1),
('individual_retirement', 'Oui, Plan retraite individuel', 2), ('individual_retirement', 'Yes, individual retirement plan', 1),
('variable_by_seniority', 'Variable selon ancienneté ou statut', 2), ('variable_by_seniority', 'Variable by seniority or status', 1),
('work_phone', 'Téléphone professionnel', 2), ('work_phone', 'Work phone', 1),
('laptop', 'Ordinateur portable', 2), ('laptop', 'Laptop', 1),
('home_internet', 'Connexion internet / abonnement à domicile', 2), ('home_internet', 'Home internet/subscription', 1),
('no_equipment_assigned', 'Aucun matériel attribué', 2), ('no_equipment_assigned', 'No equipment assigned', 1),
('partial_use', 'Partiellement (usage encadré)', 2), ('partial_use', 'Partially (restricted use)', 1),
('gym_membership', 'Abonnement à une salle de sport', 2), ('gym_membership', 'Gym membership', 1),
('cultural_activities', 'Participation à des activités culturelles (cinéma, théâtre, musées)', 2), ('cultural_activities', 'Participation in cultural activities (cinema, theater, museums)', 1),
('sports_team_building', 'Organisation d’activités sportives ou de team building', 2), ('sports_team_building', 'Organization of sports or team building activities', 1),
('holiday_vouchers', 'Chèques vacances', 2), ('holiday_vouchers', 'Holiday vouchers', 1),
('childcare_services', 'Services d\'aide à la garde d’enfants', 2), ('childcare_services', 'Childcare support services', 1),
('school_fees', 'Prise en charge de frais de scolarité (enfants à charge)', 2), ('school_fees', 'School fees coverage (dependent children)', 1),
('category_dependent', 'Non, ils dépendent de la catégorie de poste', 2), ('category_dependent', 'No, depends on job category', 1),
('seniority_dependent', 'Non, ils dépendent de l’ancienneté', 2), ('seniority_dependent', 'No, depends on seniority', 1); 
-- General Policy
INSERT INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('yes', 'Q10-GP-A', NULL, 0),
  ('no', 'Q10-GP-A', NULL, 0),
  ('in_progress', 'Q10-GP-A', NULL, 0);
INSERT INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('onboarding_contract', 'Q10-GP-B', NULL, 0),
  ('intranet_portal', 'Q10-GP-B', NULL, 0),
  ('manager_communication', 'Q10-GP-B', NULL, 0),
  ('no_formal_communication', 'Q10-GP-B', NULL, 0);
-- Meal Benefits
INSERT INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('executives', 'Q10-MB-1.1', NULL, 0),
  ('middle_managers', 'Q10-MB-1.1', NULL, 0),
  ('managers', 'Q10-MB-1.1', NULL, 0),
  ('commercial', 'Q10-MB-1.1', NULL, 0),
  ('professionals', 'Q10-MB-1.1', NULL, 0),
  ('support_tech', 'Q10-MB-1.1', NULL, 0),
  ('support_professional', 'Q10-MB-1.1', NULL, 0),
  ('labor', 'Q10-MB-1.1', NULL, 0);
INSERT INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('meal_voucher', 'Q10-MB-1.2', NULL, 0),
  ('company_canteen', 'Q10-MB-1.2', NULL, 0),
  ('other_meal_benefit', 'Q10-MB-1.2', NULL, 1);
INSERT INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('meal_3tnd', 'Q10-MB-1.3', 'meal_voucher', 0),
  ('meal_4tnd', 'Q10-MB-1.3', 'meal_voucher', 0),
  ('meal_5tnd', 'Q10-MB-1.3', 'meal_voucher', 0),
  ('meal_6tnd', 'Q10-MB-1.3', 'meal_voucher', 0),
  ('meal_7tnd', 'Q10-MB-1.3', 'meal_voucher', 0),
  ('meal_8tnd', 'Q10-MB-1.3', 'meal_voucher', 0),
  ('meal_10tnd', 'Q10-MB-1.3', 'meal_voucher', 0),
  ('other_option', 'Q10-MB-1.3', 'meal_voucher', 1);
INSERT INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('meal_20', 'Q10-MB-1.4', 'meal_voucher', 0),
  ('meal_22', 'Q10-MB-1.4', 'meal_voucher', 0),
  ('meal_24', 'Q10-MB-1.4', 'meal_voucher', 0),
  ('other_option', 'Q10-MB-1.4', 'meal_voucher', 1);
INSERT INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('equipped_kitchen', 'Q10-MB-1.5', NULL, 0),
  ('microwave', 'Q10-MB-1.5', NULL, 0),
  ('refrigerator', 'Q10-MB-1.5', NULL, 0),
  ('coffee_machine', 'Q10-MB-1.5', NULL, 0),
  ('snack_vending', 'Q10-MB-1.5', NULL, 0),
  ('no_equipment', 'Q10-MB-1.5', NULL, 0);
-- Health & Life Insurance
INSERT INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('mandatory_health', 'Q10-HI-2.1', NULL, 0),
  ('optional_health', 'Q10-HI-2.1', NULL, 0),
  ('no', 'Q10-HI-2.1', NULL, 0);
INSERT INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('100_percent', 'Q10-HI-2.2','mandatory_health', 0),
  ('75_percent', 'Q10-HI-2.2', 'mandatory_health', 0),
  ('66_percent', 'Q10-HI-2.2', 'mandatory_health', 0),
  ('50_percent', 'Q10-HI-2.2', 'mandatory_health', 0),
  ('other_option', 'Q10-HI-2.2', 'mandatory_health', 1),
  ('no', 'Q10-HI-2.2','mandatory_health', 0),
  
  ('100_percent', 'Q10-HI-2.2','optional_health', 0),
  ('75_percent', 'Q10-HI-2.2', 'optional_health', 0),
  ('66_percent', 'Q10-HI-2.2', 'optional_health', 0),
  ('50_percent', 'Q10-HI-2.2', 'optional_health', 0),
  ('other_option', 'Q10-HI-2.2', 'optional_health', 1),
  ('no', 'Q10-HI-2.2','optional_health', 0);
  
INSERT INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('health_insurance', 'Q10-HI-2.3', NULL, 0),
  ('health_life_insurance', 'Q10-HI-2.3', NULL, 0),
  ('health_life_disability', 'Q10-HI-2.3', NULL, 0);
  
INSERT INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('yes', 'Q10-HI-2.4', NULL, 0),
  ('no', 'Q10-HI-2.4', NULL, 0),
  ('life_option', 'Q10-HI-2.4', NULL, 0);
INSERT INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('executives', 'Q10-HI-2.5', 'yes', 0),
  ('middle_managers', 'Q10-HI-2.5', 'yes', 0),
  ('managers', 'Q10-HI-2.5', 'yes', 0),
  ('seniority_based', 'Q10-HI-2.5', 'yes', 0),
  ('other_option', 'Q10-HI-2.5', 'yes', 1),
  
  ('executives', 'Q10-HI-2.5', 'life_option', 0),
  ('middle_managers', 'Q10-HI-2.5', 'life_option', 0),
  ('managers', 'Q10-HI-2.5', 'life_option', 0),
  ('seniority_based', 'Q10-HI-2.5', 'life_option', 0),
  ('other_option', 'Q10-HI-2.5', 'life_option', 1);
-- Retirement Plan
INSERT INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('cavis_plan', 'Q10-RP-3.1', NULL, 0),
  ('individual_retirement', 'Q10-RP-3.1', NULL, 0),
  ('other_option', 'Q10-RP-3.1', NULL, 1);
  
INSERT INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('yes', 'Q10-RP-3.2', 'cavis_plan', 0),
  ('no', 'Q10-RP-3.2', 'cavis_plan', 0),
  ('variable_by_seniority', 'Q10-RP-3.2', 'cavis_plan', 0);
  
-- Professional Equipment
INSERT INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('work_phone', 'Q10-PE-3.1', NULL, 0),
  ('laptop', 'Q10-PE-3.1', NULL, 0),
  ('home_internet', 'Q10-PE-3.1', NULL, 0),
  ('no_equipment_assigned', 'Q10-PE-3.1', NULL, 0);
INSERT INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('yes', 'Q10-PE-3.2', NULL, 0),
  ('partial_use', 'Q10-PE-3.2', NULL, 0),
  ('no', 'Q10-PE-3.2', NULL, 0);
-- Cultural, Sports & Family
INSERT INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('yes', 'Q10-CSF-4.1', NULL, 0),
  ('no', 'Q10-CSF-4.1', NULL, 0);
INSERT INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('gym_membership', 'Q10-CSF-4.2', 'yes', 0),
  ('cultural_activities', 'Q10-CSF-4.2', 'yes', 0),
  ('sports_team_building', 'Q10-CSF-4.2', 'yes', 0),
  ('holiday_vouchers', 'Q10-CSF-4.2', 'yes', 0),
  ('childcare_services', 'Q10-CSF-4.2', 'yes', 0),
  ('school_fees', 'Q10-CSF-4.2', 'yes', 0),
  ('other_option', 'Q10-CSF-4.2', 'yes', 1);
INSERT INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('yes', 'Q10-CSF-4.3', 'yes', 0),
  ('category_dependent', 'Q10-CSF-4.3', 'yes', 0),
  ('seniority_dependent', 'Q10-CSF-4.3', 'yes', 0),
  ('other_option', 'Q10-CSF-4.3', 'yes', 1); 