use  socle;
--  Insert into solution_quiz for Quiz 3 Attraction, Rétention et fin de contrat
INSERT INTO solution_quiz (id, quizCode, quiz_image, averagetime)
VALUES
  (3, 'quiz_3_Attraction_Retention_and_Termination',
   'Questionnaire 3 -Attraction, Rétention et fin de contrat.jpg',
   15);
-- Insert into solution_quiz_translate for Quiz 3 (French & English)
INSERT INTO solution_quiz_translate (quizCode, title, description, short_description, languageId)
VALUES
  ('quiz_3_Attraction_Retention_and_Termination',
   'Questionnaire 3 -Attraction, Rétention et fin de contrat',
   'Évaluation des stratégies d\'attraction et de rétention des talents, ainsi que des processus de fin de contrat',
   'Évaluation des stratégies d\'attraction, rétention et fin de contrat', 2),
  ('quiz_3_Attraction_Retention_and_Termination',
   'Quiz 3 - Talent Attraction, Retention & Offboarding',
   'Assessment of talent attraction and retention strategies, and employee offboarding processes',
   'Assessment of attraction, retention & offboarding strategies', 1);
-- Insert into solution_quiz_section for Quiz 3
INSERT INTO solution_quiz_section (sectionCode, quizCode, section_order)
VALUES
  ('Talent_Attraction_Strategies','quiz_3_Attraction_Retention_and_Termination', 1),
  ('Talent_Retention_Strategies','quiz_3_Attraction_Retention_and_Termination', 2),
  ('Employment_Termination_Process', 'quiz_3_Attraction_Retention_and_Termination', 3);
--  Insert translations for those sections
INSERT INTO solution_quiz_section_translate (sectionCode, title, languageId)
VALUES
  -- English
  ('Talent_Attraction_Strategies', 'Talent Attraction Strategies', 1),
  ('Talent_Retention_Strategies', 'Talent Retention Strategies', 1),
  ('Employment_Termination_Process', 'Employment Termination Process', 1),
  -- French
  ('Talent_Attraction_Strategies', 'Stratégies d\'Attraction des Talents', 2),
  ('Talent_Retention_Strategies',  'Stratégies de Rétention des Talents', 2),
  ('Employment_Termination_Process','Cessation d\'Emploi', 2);
-- Insert questions for each section
INSERT INTO solution_quiz_section_questions
  (quizCode, questionCode, sectionCode, idparent, type, question_order, echartType)
VALUES
  -- Section 1: Talent_Attraction_Strategies (Q3-ATS-1 → Q3-ATS-4)
  ('quiz_3_Attraction_Retention_and_Termination', 'Q3-ATS-1', 'Talent_Attraction_Strategies', NULL, 'CM', 1, 'Bar'),
  ('quiz_3_Attraction_Retention_and_Termination', 'Q3-ATS-2', 'Talent_Attraction_Strategies', NULL, 'CM', 2, 'Bar'),
  ('quiz_3_Attraction_Retention_and_Termination', 'Q3-ATS-3', 'Talent_Attraction_Strategies', NULL, 'CM', 3, 'Bar'),
  ('quiz_3_Attraction_Retention_and_Termination', 'Q3-ATS-4', 'Talent_Attraction_Strategies', NULL, 'CM', 4, 'Bar'),
  -- Section 2: Talent_Retention_Strategies (Q3-RTS-5 → Q3-RTS-9)
  ('quiz_3_Attraction_Retention_and_Termination', 'Q3-RTS-5', 'Talent_Retention_Strategies', NULL,      'CM', 5, 'Bar'),
  ('quiz_3_Attraction_Retention_and_Termination', 'Q3-RTS-6', 'Talent_Retention_Strategies', NULL,      'CM', 6, 'Bar'),
  ('quiz_3_Attraction_Retention_and_Termination', 'Q3-RTS-7', 'Talent_Retention_Strategies', NULL,      'CU', 7, 'Pie'),
  ('quiz_3_Attraction_Retention_and_Termination', 'Q3-RTS-8', 'Talent_Retention_Strategies', 'Q3-RTS-7', 'CU', 8, 'Pie'),
  ('quiz_3_Attraction_Retention_and_Termination', 'Q3-RTS-9', 'Talent_Retention_Strategies', NULL,      'CM', 9, 'Bar'),
  -- Section 3: Employment_Termination_Process (Q3-ET-10 → Q3-ET-14)
  ('quiz_3_Attraction_Retention_and_Termination', 'Q3-ET-10', 'Employment_Termination_Process', NULL,      'CM', 10, 'Bar'),
  ('quiz_3_Attraction_Retention_and_Termination', 'Q3-ET-11', 'Employment_Termination_Process', NULL,      'CU', 11, 'Pie'),
  ('quiz_3_Attraction_Retention_and_Termination', 'Q3-ET-12', 'Employment_Termination_Process', 'Q3-ET-11', 'CM', 12, 'Bar'),
  ('quiz_3_Attraction_Retention_and_Termination', 'Q3-ET-13', 'Employment_Termination_Process', NULL,      'CM', 13, 'Bar'),
  ('quiz_3_Attraction_Retention_and_Termination', 'Q3-ET-14', 'Employment_Termination_Process', NULL,      'CU', 14, 'Pie');
--  Insert translations for all questions (English & French)
INSERT INTO solution_quiz_section_questions_translate (questionCode, title, languageId)
VALUES
  -- English
  ('Q3-ATS-1', 'Which recruitment channels do you use to attract new talent?',1),
  ('Q3-ATS-2', 'Which aspects of your company are most attractive to potential hires?', 1),
  ('Q3-ATS-3', 'What initiatives do you implement to onboard new employees?',1),
  ('Q3-ATS-4', 'How do you enhance your employer brand?', 1),
  ('Q3-RTS-5', 'What factors drive employee satisfaction and engagement?', 1),
  ('Q3-RTS-6', 'Which programs have you implemented to retain key talent?',1),
  ('Q3-RTS-7', 'Do you conduct employee satisfaction and engagement surveys?', 1),
  ('Q3-RTS-8', 'How often do you run these surveys?',1),
  ('Q3-RTS-9', 'How are outstanding employee performances recognized and rewarded?', 1),
  ('Q3-ET-10','What are the most common reasons employees leave your company?',1),
  ('Q3-ET-11','Do you conduct exit interviews to understand departure reasons?',1),
  ('Q3-ET-12','How do you use the insights gathered from exit interviews?', 1),
  ('Q3-ET-13','What measures have you implemented to prevent voluntary turnover?', 1),
  ('Q3-ET-14','Do you have a succession plan for key-role departures?', 1),
  -- French
  ('Q3-ATS-1', 'Quels canaux de recrutement utilisez-vous pour attirer de nouveaux talents ?', 2),
  ('Q3-ATS-2', 'Quels éléments de votre entreprise sont les plus attractifs pour les candidats potentiels ?', 2),
  ('Q3-ATS-3', 'Quelles initiatives mettez-vous en place pour faciliter l’intégration des nouveaux employés ?', 2),
  ('Q3-ATS-4', 'Comment travaillez-vous à améliorer la marque employeur de votre entreprise ?', 2),
  ('Q3-RTS-5', 'Quels sont les principaux éléments qui contribuent à la satisfaction et à l’engagement des employés ?', 2),
  ('Q3-RTS-6', 'Quels programmes spécifiques avez-vous mis en place pour retenir vos talents clés ?', 2),
  ('Q3-RTS-7', 'Réalisez-vous des enquêtes de satisfaction et d’engagement des employés ?', 2),
  ('Q3-RTS-8', 'À quelle fréquence réalisez-vous ces enquêtes ?', 2),
  ('Q3-RTS-9', 'Comment les performances exceptionnelles des employés sont-elles reconnues et récompensées ?', 2),
  ('Q3-ET-10','Quels sont les motifs les plus courants pour lesquels les employés quittent votre entreprise ?', 2),
  ('Q3-ET-11','Menez-vous des entretiens de départ pour comprendre les raisons du départ des employés ?', 2),
  ('Q3-ET-12','Comment utilisez-vous les informations recueillies lors des entretiens de départ ?', 2),
  ('Q3-ET-13','Quelles mesures avez-vous mises en place pour prévenir les départs volontaires ?', 2),
  ('Q3-ET-14','Avez-vous un plan de succession en place pour assurer la continuité des activités en cas de départ d’un employé clé ?', 2);
--   all items codes & names 
INSERT INTO solution_reponses_items (itemCode, itemName)
VALUES
  -- Q3-ATS-1
  ('online_job_sites',          'Online job sites (Indeed, Monster, etc.)'),
  ('internal_referrals',        'Internal referrals'),
  ('external_agencies',         'External recruitment agencies'),
  ('job_fairs',                 'Job fairs & recruiting events'),
  ('university_partnerships',   'University / school partnerships'),
  -- Q3-ATS-2
  ('company_culture',           'Company culture (values, mission)'),
  ('career_opportunities',      'Career development opportunities'),
  ('competitive_compensation',  'Competitive pay & benefits'),
  ('work_flexibility',          'Work flexibility (remote, hours)'),
  ('brand_reputation',          'Employer brand & reputation'),
  ('innovation_tech',           'Innovation & technology used'),
  -- Q3-ATS-3
  ('formal_onboarding',         'Formal onboarding programs'),
  ('mentoring_program',         'Mentoring / buddy programs'),
  ('initial_training',          'Initial training sessions'),
  ('welcome_meetings',          'Welcome meetings with leadership'),
  -- Q3-ATS-4
  ('employer_rankings',         'Participation in employer rankings'),
  ('internal_ambassadors',      'Internal ambassador programs'),
  ('social_media_campaigns',    'Social media employer campaigns'),
  ('employee_testimonials',     'Employee testimonials'),
  -- Q3-RTS-5
  ('recognition_rewards',       'Recognition & rewards'),
  ('career_development',        'Career development paths'),
  ('positive_culture',          'Positive work culture'),
  ('benefits',                  'Employee benefits'),
  ('work_life_balance',         'Work-life balance'),
  ('leadership_quality',        'Leadership & management quality'),
  -- Q3-RTS-6
  ('personalized_plans',        'Personalized career plans'),
  ('performance_increases',     'Performance-based salary increases'),
  ('stock_options',             'Stock option / equity plans'),
  ('mentorship_programs',       'Mentorship & development programs'),
  ('wellness_programs',         'Wellness & well-being programs'),
  ('flexible_benefits',         'Flexible benefits'),
  -- Q3-RTS-8
  ('semi_annually',             'Semi-annually'),
  -- Q3-RTS-9
  ('monetary_rewards',          'Monetary rewards'),
  ('public_recognition',        'Public recognition'),
  ('training_opportunities',    'Training & development opportunities'),
  ('promotions_internal',       'Promotions & internal mobility'),
  -- Q3-ET-10
  ('better_opportunity',        'Better opportunity elsewhere'),
  ('salary_dissatisfaction',    'Salary dissatisfaction'),
  ('career_stagnation',         'Lack of career progression'),
  ('internal_conflict',         'Internal conflicts'),
  ('burnout',                   'Burnout or stress'),
  ('worklife_search',           'Seeking better work-life balance'),
-- Q3-ET-11
('yes_systematically',     'Yes, systematically'),
('yes_not_for_all_departures', 'Yes, but not for all departures'),
 ('no_formal',              'No, not in a formal way'),
  -- Q3-ET-12
  ('adjust_hr_practices',       'To adjust HR practices'),
  ('review_talent_policies',    'To review talent policies'),
  ('improve_work_conditions',   'To improve working conditions'),
  ('inform_future_retention',   'To inform future retention strategies'),
  -- Q3-ET-13
  ('preventive_measures',       'Preventive turnover measures'),
  ('improve_conditions',        'Improve working conditions'),
  ('wellness_initiatives',      'Wellness & well-being initiatives'),
  ('regular_hr_reviews',        'Regular HR policy reviews'),
  -- Q3-ET-14
  ('succession_for_all',        'Yes, for all critical roles'),
  ('succession_selective',      'Yes, but only for select roles'),
  ('no_plan',                   'No formal succession plan'),
  
  ('social_networks','Social networks (LinkedIn, Facebook, etc.)');
  
--  Link items to questions
INSERT INTO solution_quiz_section_questions_items
  (itemCode, questionCode, itemParentId, isOther)
VALUES
  -- Q3-ATS-1
  ('social_networks', 'Q3-ATS-1', NULL, 0),
  ('online_job_sites','Q3-ATS-1', NULL, 0),
  ('internal_referrals', 'Q3-ATS-1', NULL, 0),
  ('external_agencies',  'Q3-ATS-1', NULL, 0),
  ('job_fairs', 'Q3-ATS-1', NULL, 0),
  ('university_partnerships', 'Q3-ATS-1', NULL, 0),
  ('other-please-specify', 'Q3-ATS-1', NULL, 1),
  -- Q3-ATS-2
  ('company_culture',  'Q3-ATS-2', NULL, 0),
  ('career_opportunities', 'Q3-ATS-2', NULL, 0),
  ('competitive_compensation','Q3-ATS-2', NULL, 0),
  ('work_flexibility', 'Q3-ATS-2', NULL, 0),
  ('brand_reputation','Q3-ATS-2', NULL, 0),
  ('innovation_tech','Q3-ATS-2', NULL, 0),
  ('other-please-specify', 'Q3-ATS-2', NULL, 1),
  -- Q3-ATS-3
  ('formal_onboarding','Q3-ATS-3', NULL, 0),
  ('mentoring_program','Q3-ATS-3', NULL, 0),
  ('initial_training','Q3-ATS-3', NULL, 0),
  ('welcome_meetings','Q3-ATS-3', NULL, 0),
  ('other-please-specify', 'Q3-ATS-3', NULL, 1),
  -- Q3-ATS-4
  ('employer_rankings','Q3-ATS-4', NULL, 0),
  ('internal_ambassadors','Q3-ATS-4', NULL, 0),
  ('social_media_campaigns', 'Q3-ATS-4', NULL, 0),
  ('employee_testimonials', 'Q3-ATS-4', NULL, 0),
  ('other-please-specify', 'Q3-ATS-4', NULL, 1),
  -- Q3-RTS-5
  ('recognition_rewards', 'Q3-RTS-5', NULL, 0),
  ('career_development', 'Q3-RTS-5', NULL, 0),
  ('positive_culture',   'Q3-RTS-5', NULL, 0),
  ('benefits', 'Q3-RTS-5', NULL, 0),
  ('work_life_balance','Q3-RTS-5', NULL, 0),
  ('leadership_quality','Q3-RTS-5', NULL, 0),
  ('other-please-specify',  'Q3-RTS-5', NULL, 1),
  -- Q3-RTS-6
  ('personalized_plans','Q3-RTS-6', NULL, 0),
  ('performance_increases','Q3-RTS-6', NULL, 0),
  ('stock_options','Q3-RTS-6', NULL, 0),
  ('mentorship_programs','Q3-RTS-6', NULL, 0),
  ('wellness_programs','Q3-RTS-6', NULL, 0),
  ('flexible_benefits', 'Q3-RTS-6', NULL, 0),
  ('other-please-specify','Q3-RTS-6', NULL, 1),
  -- Q3-RTS-7
  ('yes','Q3-RTS-7', NULL, 0),
  ('no','Q3-RTS-7', NULL, 0),
  -- Q3-RTS-8
  ('quarterly','Q3-RTS-8', 'yes', 0),
  ('semi_annually','Q3-RTS-8', 'yes', 0),
  ('annually','Q3-RTS-8', 'yes', 0),
  ('other-please-specify', 'Q3-RTS-8', 'yes', 1),
  -- Q3-RTS-9
  ('monetary_rewards','Q3-RTS-9', NULL, 0),
  ('public_recognition', 'Q3-RTS-9', NULL, 0),
  ('training_opportunities', 'Q3-RTS-9', NULL, 0),
  ('promotions_internal', 'Q3-RTS-9', NULL, 0),
  ('other-please-specify','Q3-RTS-9', NULL, 1),
  -- Q3-ET-10
  ('better_opportunity', 'Q3-ET-10', NULL, 0),
  ('salary_dissatisfaction',  'Q3-ET-10', NULL, 0),
  ('career_stagnation','Q3-ET-10', NULL, 0),
  ('internal_conflict','Q3-ET-10', NULL, 0),
  ('burnout','Q3-ET-10', NULL, 0),
  ('worklife_search','Q3-ET-10', NULL, 0),
  ('other-please-specify',  'Q3-ET-10', NULL, 1),
  -- Q3-ET-11
 ('yes_systematically', 'Q3-ET-11',NULL, 0),
('yes_not_for_all_departures', 'Q3-ET-11', NULL,0),
('no_formal', 'Q3-ET-11',NULL ,0),
  -- Q3-ET-12
  ('adjust_hr_practices',  'Q3-ET-12','yes_systematically', 0),
  ('review_talent_policies',  'Q3-ET-12', 'yes_systematically', 0),
  ('improve_work_conditions', 'Q3-ET-12','yes_systematically', 0),
  ('inform_future_retention', 'Q3-ET-12', 'yes_systematically', 0),
  ('other-please-specify',    'Q3-ET-12', 'yes_systematically', 1),
  -- Q3-ET-13
  ('preventive_measures','Q3-ET-13', NULL, 0),
  ('improve_conditions', 'Q3-ET-13', NULL, 0),
  ('wellness_initiatives','Q3-ET-13', NULL, 0),
  ('regular_hr_reviews', 'Q3-ET-13', NULL, 0),
  ('other-please-specify',  'Q3-ET-13', NULL, 1),
  -- Q3-ET-14
  ('succession_for_all', 'Q3-ET-14', NULL, 0),
  ('succession_selective',  'Q3-ET-14', NULL, 0),
  ('no_plan', 'Q3-ET-14', NULL, 0);
-- Insert translations for each item ( French)
INSERT INTO solution_quiz_question_items_translate (itemCode, itemValue, languageId)
VALUES
  -- Q3-ATS-1
  ('online_job_sites',   'Sites de recrutement en ligne (LinkedIn, etc.)', 2),
  ('internal_referrals', 'Recommandations internes',  2),
  ('external_agencies', 'Cabinets de recrutement externes',   2),
  ('job_fairs',  'Foires et événements de recrutement',  2),
  ('university_partnerships', 'Partenariats avec universités/écoles', 2),
  -- Q3-ATS-2
  ('company_culture', 'Culture d''entreprise (valeurs, mission, vision)', 2),
  ('career_opportunities','Opportunités de développement de carrière (promotions, mobilité interne)', 2),
  ('competitive_compensation','Rémunération compétitive et avantages sociaux (assurance, retraite, etc.)',2),
  ('work_flexibility', 'Flexibilité du travail (télétravail, horaires)', 2),
  ('brand_reputation', 'Réputation et image de marque de l''entreprise',    2),
  ('innovation_tech','Innovation et technologies utilisées',  2),
  -- Q3-ATS-3
  ('formal_onboarding', 'Programmes d''intégration formels', 2),
  ('mentoring_program','Parrainage ou mentorat',  2),
  ('initial_training','Sessions de formation initiale', 2),
  ('welcome_meetings','Réunions d''accueil avec la direction', 2),
  -- Q3-ATS-4
  ('employer_rankings', 'Participation à des classements d''employeurs',  2),
  ('internal_ambassadors',    'Programme d''ambassadeurs internes', 2),
  ('social_media_campaigns',  'Campagnes de communication sur les réseaux sociaux', 2),
  ('employee_testimonials',   'Témoignages de salariés', 2),
  -- Q3-RTS-5
  ('recognition_rewards',  'Reconnaissance et récompenses (bonus, primes, etc.)', 2),
  ('career_development', 'Possibilités d’évolution de carrière (promotions, formation continue)',   2),
  ('positive_culture', 'Culture de travail positive (collaboration, esprit d''équipe)', 2),
  ('benefits',   'Avantages sociaux (assurances, congés, etc.)', 2),
  ('work_life_balance','Équilibre travail-vie privée (flexibilité des horaires, télétravail)',2),
  ('leadership_quality', 'Leadership et gestion de la direction',   2),
  -- Q3-RTS-6
  ('personalized_plans', 'Plans de carrière personnalisés', 2),
  ('performance_increases', 'Augmentations salariales basées sur la performance', 2),
  ('stock_options',           'Plans de stock-options ou participation', 2),
  ('mentorship_programs',   'Programmes de mentorat et de développement',  2),
  ('wellness_programs',  'Programmes de bien-être (activités physiques, soutien psychologique)',  2),
  ('flexible_benefits', 'Avantages flexibles (congés supplémentaires, télétravail)', 2),
  -- Q3-RTS-8
  ('quarterly', 'Trimestriellement',  2),
  ('semi_annually', 'Semestriellement',2),
 
  -- Q3-RTS-9
  ('monetary_rewards',  'Récompenses monétaires (primes, bonus)',  2),
  ('public_recognition','Reconnaissance publique (cérémonies, communications internes)', 2),
  ('training_opportunities',  'Opportunités de formation ou de développement personnel',  2),
  ('promotions_internal',  'Promotions et mobilité interne', 2),
  -- Q3-ET-10
  ('better_opportunity',  'Meilleure opportunité ailleurs',2),
  ('salary_dissatisfaction',  'Insatisfaction salariale',  2),
  ('career_stagnation', 'Manque de progression', 2),
  ('internal_conflict','Conflits internes',  2),
  ('burnout', 'Épuisement professionnel',2),
  ('worklife_search', 'Recherche d''équilibre travail-vie privée',  2),
  
    -- Q3-ET-11 
  ('yes_systematically', 'Oui, systématiquement', 2),
  ('yes_not_for_all_departures',      'Oui, mais pas pour tous les départs', 2),
  ('no_formal',          'Non, pas de manière formelle', 2),
  
  -- Q3-ET-12
  ('adjust_hr_practices', 'Pour ajuster les pratiques RH',2),
  ('review_talent_policies',  'Pour revoir les politiques de gestion des talents', 2),
  ('improve_work_conditions', 'Pour améliorer les conditions de travail',  2),
  ('inform_future_retention', 'Pour informer les stratégies de rétention futures',2),
  -- Q3-ET-13
  ('preventive_measures', 'Augmentations salariales basées sur la performance',  2),
  ('improve_conditions',  'Amélioration des conditions de travail', 2),
  ('wellness_initiatives', 'Programmes de bien-être', 2),
  ('regular_hr_reviews', 'Révisions régulières des politiques RH',  2),
  -- Q3-ET-14
  ('succession_for_all', 'Oui, pour tous les postes critiques',2),
  ('succession_selective', 'Oui, mais uniquement pour certains postes', 2),
  ('no_plan','Non, pas de plan de succession formel',2),
 ('social_networks', 'Réseaux sociaux (LinkedIn, Facebook, etc.)', 2);
  
  
  INSERT INTO solution_quiz_question_items_translate (itemCode, itemValue, languageId)
VALUES
  -- Q3-ATS-1
  ('online_job_sites',  'Online job sites (Indeed, Monster, etc.)',   1),
  ('internal_referrals', 'Internal referrals',    1),
  ('external_agencies', 'External recruitment agencies',  1),
  ('job_fairs',  'Job fairs & recruiting events',   1),
  ('university_partnerships', 'University / school partnerships',1),
  -- Q3-ATS-2
  ('company_culture', 'Company culture (values, mission)', 1),
  ('career_opportunities', 'Career development opportunities', 1),
  ('competitive_compensation','Competitive pay & benefits', 1),
  ('work_flexibility','Work flexibility (remote, hours)',1),
  ('brand_reputation', 'Employer brand & reputation',1),
  ('innovation_tech',  'Innovation & technology used',1),
  -- Q3-ATS-3
  ('formal_onboarding', 'Formal onboarding programs', 1),
  ('mentoring_program','Mentoring / buddy programs',   1),
  ('initial_training','Initial training sessions',  1),
  ('welcome_meetings', 'Welcome meetings with leadership',  1),
  -- Q3-ATS-4
  ('employer_rankings',   'Participation in employer rankings',  1),
  ('internal_ambassadors', 'Internal ambassador programs', 1),
  ('social_media_campaigns','Social media employer campaigns', 1),
  ('employee_testimonials','Employee testimonials', 1),
  -- Q3-RTS-5
  ('recognition_rewards','Recognition & rewards',1),
  ('career_development', 'Career development paths', 1),
  ('positive_culture', 'Positive work culture', 1),
  ('benefits', 'Employee benefits', 1),
  ('work_life_balance', 'Work–life balance',1),
  ('leadership_quality','Leadership & management quality',1),
  -- Q3-RTS-6
  ('personalized_plans', 'Personalized career plans',1),
  ('performance_increases', 'Performance-based salary increases', 1),
  ('stock_options', 'Stock option / equity plans',  1),
  ('mentorship_programs', 'Mentorship & development programs', 1),
  ('wellness_programs',  'Wellness & well-being programs', 1),
  ('flexible_benefits', 'Flexible benefits',   1),
  -- Q3-RTS-8
  ('quarterly',  'Quarterly', 1),
  ('semi_annually','Semi-annually', 1),
  -- Q3-RTS-9
  ('monetary_rewards','Monetary rewards', 1),
  ('public_recognition',  'Public recognition', 1),
  ('training_opportunities',  'Training & development opportunities',1),
  ('promotions_internal', 'Promotions & internal mobility',1),
  -- Q3-ET-10
  ('better_opportunity','Better opportunity elsewhere',1),
  ('salary_dissatisfaction',  'Salary dissatisfaction',1),
  ('career_stagnation',  'Lack of career progression',1),
  ('internal_conflict', 'Internal conflicts',1),
  ('burnout', 'Burnout or stress',  1),
  ('worklife_search', 'Seeking better work–life balance',1),
  -- Q3-ET-11 
  ('yes_systematically', 'Yes, systematically', 1),
  ('yes_not_for_all_departures',      'Yes, but not for all departures', 1),
  ('no_formal',          'No, not in a formal way', 1),
  -- Q3-ET-12
  ('adjust_hr_practices', 'To adjust HR practices', 1),
  ('review_talent_policies', 'To review talent policies', 1),
  ('improve_work_conditions', 'To improve working conditions',1),
  ('inform_future_retention', 'To inform future retention strategies', 1),
  -- Q3-ET-13
  ('preventive_measures', 'Preventive turnover measures', 1),
  ('improve_conditions', 'Improve working conditions',  1),
  ('wellness_initiatives',  'Wellness & well-being initiatives', 1),
  ('regular_hr_reviews', 'Regular HR policy reviews', 1),
  -- Q3-ET-14
  ('succession_for_all','Yes, for all critical roles', 1),
  ('succession_selective','Yes, but only for select roles',1),
   ('social_networks', 'Social networks (LinkedIn, Facebook, etc.)', 1),
  ('no_plan','No formal succession plan',1);