use socle;
--  quiz 5 Éléments garantis et Allocations”
-- 1) Quiz definition
INSERT INTO solution_quiz (id, quizCode, quiz_image, averagetime)
VALUES
  (5, 'quiz_5_Elements_Garantis_Allocations',
   'Questionnaire 5.jpg',
   20);
-- 2) Quiz translations
INSERT INTO solution_quiz_translate (quizCode, title, description, short_description, languageId)
VALUES
  ('quiz_5_Elements_Garantis_Allocations',
   'Questionnaire 5 – Éléments garantis et allocations',
   'Étude des éléments garantis et allocations en espèces offerts par l’entreprise',
   'Étude des éléments garantis et allocations en espèces',
   2),
  ('quiz_5_Elements_Garantis_Allocations',
   'Quiz 5 – Guaranteed Elements and Cash Allowances',
   'Survey of guaranteed elements and cash allowances provided by the company',
   'Survey of guaranteed elements and cash allowances',
   1);
-- 3) Sections
INSERT INTO solution_quiz_section (sectionCode, quizCode, section_order)
VALUES
  ('Fixed_Salary_Months',            'quiz_5_Elements_Garantis_Allocations', 1),
  ('Transport_Fee_Contribution',     'quiz_5_Elements_Garantis_Allocations', 2),
  ('Transport_Allocation_Details',   'quiz_5_Elements_Garantis_Allocations', 3),
  ('Housing_Allocation_Details',     'quiz_5_Elements_Garantis_Allocations', 4),
  ('Personal_Loans_Details',         'quiz_5_Elements_Garantis_Allocations', 5),
  ('Social_Association_Indemnities', 'quiz_5_Elements_Garantis_Allocations', 6);
-- 4) Section translations
INSERT INTO solution_quiz_section_translate (sectionCode, title, languageId)
VALUES
  -- English
  ('Fixed_Salary_Months',            'Fixed Salary Months',         1),
  ('Transport_Fee_Contribution',     'Transport Fee Contribution',  1),
  ('Transport_Allocation_Details',   'Transport Allowance Details', 1),
  ('Housing_Allocation_Details',     'Housing Allowance Details',   1),
  ('Personal_Loans_Details',         'Personal Loans Details',      1),
  ('Social_Association_Indemnities', 'Club & Association Indemnities',1),
  -- French
  ('Fixed_Salary_Months',            'Nombre de mois de salaire',   2),
  ('Transport_Fee_Contribution',     'Participation frais transport',2),
  ('Transport_Allocation_Details',   'Détails allocation transport',2),
  ('Housing_Allocation_Details',     'Détails allocation logement', 2),
  ('Personal_Loans_Details',         'Détails prêts personnels',    2),
  ('Social_Association_Indemnities', 'Indemnités clubs & associations',2);
-- 5) Questions & chart types
INSERT INTO solution_quiz_section_questions
  (questionCode, sectionCode, quizCode, idparent, type, question_order, echartType)
VALUES
  -- Section 1
  ('Q5-FSM-1',  'Fixed_Salary_Months',            'quiz_5_Elements_Garantis_Allocations', NULL,   'CU', 1,  'Pie'),
  -- Section 2
  ('Q5-TFC-2',  'Transport_Fee_Contribution',     'quiz_5_Elements_Garantis_Allocations', NULL,   'CU', 2,  'Pie'),
  ('Q5-TFC-3',  'Transport_Fee_Contribution',     'quiz_5_Elements_Garantis_Allocations', 'Q5-TFC-2','CM_all',3,  'Bar'),
  -- Section 3
  ('Q5-TAD-4',  'Transport_Allocation_Details',   'quiz_5_Elements_Garantis_Allocations', NULL,   'CU', 4,  'Pie'),
  ('Q5-TAD-5',  'Transport_Allocation_Details',   'quiz_5_Elements_Garantis_Allocations', 'Q5-TAD-4','CM_all',5,  'Bar'),
  ('Q5-TAD-6',  'Transport_Allocation_Details',   'quiz_5_Elements_Garantis_Allocations', 'Q5-TAD-4','CM',6,  'Pie'),
  ('Q5-TAD-7',  'Transport_Allocation_Details',   'quiz_5_Elements_Garantis_Allocations', 'Q5-TAD-6','CM',7,  'tab_num'),
  -- Section 4
  ('Q5-HAD-8',  'Housing_Allocation_Details',     'quiz_5_Elements_Garantis_Allocations', NULL,   'CU', 8,  'Pie'),
  ('Q5-HAD-9',  'Housing_Allocation_Details',     'quiz_5_Elements_Garantis_Allocations', 'Q5-HAD-8','CM_all',9,  'Bar'),
  ('Q5-HAD-10', 'Housing_Allocation_Details',     'quiz_5_Elements_Garantis_Allocations', 'Q5-HAD-8','CU',10, 'Pie'),
  ('Q5-HAD-11', 'Housing_Allocation_Details',     'quiz_5_Elements_Garantis_Allocations', 'Q5-HAD-10','CM',11,'tab_num'),
  -- Section 5
  ('Q5-PLD-12','Personal_Loans_Details',         'quiz_5_Elements_Garantis_Allocations', NULL,   'CU',12, 'Pie'),
  ('Q5-PLD-13','Personal_Loans_Details',         'quiz_5_Elements_Garantis_Allocations', 'Q5-PLD-12','CM_all',13,'Bar'),
  ('Q5-PLD-14','Personal_Loans_Details',         'quiz_5_Elements_Garantis_Allocations', 'Q5-PLD-12','CM',14,'tab_num'),
  ('Q5-PLD-15','Personal_Loans_Details',         'quiz_5_Elements_Garantis_Allocations', 'Q5-PLD-12','CM',15,'tab_num'),
  -- Section 6
  ('Q5-SAI-16','Social_Association_Indemnities', 'quiz_5_Elements_Garantis_Allocations', NULL,   'CU',16, 'Pie'),
  ('Q5-SAI-17','Social_Association_Indemnities', 'quiz_5_Elements_Garantis_Allocations', 'Q5-SAI-16','CM_all',17,'Bar'),
  ('Q5-SAI-18','Social_Association_Indemnities', 'quiz_5_Elements_Garantis_Allocations', NULL,   'CU',18, 'Pie'),
  ('Q5-SAI-19','Social_Association_Indemnities', 'quiz_5_Elements_Garantis_Allocations', 'Q5-SAI-18','CM_all',19,'Bar');
-- French translations for Quiz 5 questions
INSERT INTO solution_quiz_section_questions_translate (questionCode, title, languageId)
VALUES
  ('Q5-FSM-1',  'Nombre de mois de salaire de base fixes versés annuellement', 2),
  ('Q5-TFC-2',  'Votre entreprise contibue t-elle aux frais de transport (exp bus de la société…)?', 2),
  ('Q5-TFC-3',  'Si oui,  quels niveaux hiérarchiques sont concérnés par cet avantage ? ', 2),
  ('Q5-TAD-4',  'Votre entreprise fournit t-elle une allocation de transport (Participation aux frais de transport , allocation en espèce…)?', 2),
  ('Q5-TAD-5',  'Si oui,  quels niveaux hiérarchiques  sont concérnés par cet avantage ?', 2),
  ('Q5-TAD-6',  'Si oui, sous quelle forme est  accordée cette allocation de transport ?', 2),
  ('Q5-TAD-7',  'Quel est le montant moyen mensuel de cette allocation de transport ?', 2),
  
  ('Q5-HAD-8',  'Votre entreprise fournit-elle une allocation de logement ?', 2),
  ('Q5-HAD-9',  ' Si oui,  quels niveaux hiérarchiques  sont concérnés par cet avantage ? ', 2),
  ('Q5-HAD-10', 'Si oui, sous quelle forme est  accordée cette allocation de logement?', 2),
  ('Q5-HAD-11', 'Quel est le montant moyen mensuel de cette allocation de logement ?', 2),
  
  ('Q5-PLD-12','Votre entreprise accorde-t-elle des prêts personnels ?', 2),
  ('Q5-PLD-13','Si oui,  quels niveaux hiérarchiques  sont concérnés par cet avantage ?', 2),
  ('Q5-PLD-14',' Quel est le montant maximum du prêt accordé sous forme de multiple du salaire mensuel ?', 2),
  ('Q5-PLD-15','Quel est le délai maximum de remboursement du prêt personnel (nombre de mois)?', 2),
  
  ('Q5-SAI-16','Votre entreprise accordre t-elle des indemnités pour les clubs sociaux/sportifs ?', 2),
  ('Q5-SAI-17','Si oui,  quels niveaux hiérarchiques  sont concérnés par cette indemnité ? ', 2),
  ('Q5-SAI-18','Votre entreprise accordre t-elle des indemnités pour l''adhésion à une association professionnelle ?', 2),
  ('Q5-SAI-19','Si oui, quels niveaux hiérarchiques sont concernés ?', 2);
-- English translations for Quiz 5 questions
INSERT INTO solution_quiz_section_questions_translate (questionCode, title, languageId)
VALUES
  ('Q5-FSM-1',  'Number of fixed base-salary months paid annually', 1),
  ('Q5-TFC-2',  'Does your company contribute to transport costs?',    1),
  ('Q5-TFC-3',  'If yes, which hierarchical levels are covered?',     1),
  ('Q5-TAD-4',  'Does your company provide a transport allowance?',   1),
  ('Q5-TAD-5',  'If yes, which hierarchical levels are covered?',     1),
  ('Q5-TAD-6',  'In what form is this allowance granted?',            1),
  ('Q5-TAD-7',  'What is the average monthly amount?',                1),
  ('Q5-HAD-8',  'Does your company provide a housing allowance?',     1),
  ('Q5-HAD-9',  'If yes, which hierarchical levels are covered?',     1),
  ('Q5-HAD-10', 'In what form is the housing allowance granted?',    1),
  ('Q5-HAD-11', 'What is the average monthly amount?',                1),
  ('Q5-PLD-12','Does your company grant personal loans?',             1),
  ('Q5-PLD-13','If yes, which hierarchical levels are covered?',     1),
  ('Q5-PLD-14','Maximum loan amount (multiple of salary)?',          1),
  ('Q5-PLD-15','Maximum repayment term (months)?',                   1),
  ('Q5-SAI-16','Does your company pay club/sport indemnities?',      1),
  ('Q5-SAI-17','If yes, which hierarchical levels are covered?',     1),
  ('Q5-SAI-18','Does your company pay professional association indemnities?', 1),
  ('Q5-SAI-19','If yes, which hierarchical levels are covered?',     1);
  
-- 7) New response‐items for Quiz 5
INSERT INTO solution_reponses_items (itemCode, itemName)
VALUES
  ('commercial','commercial'),
  ('12_months',        '12'),
  ('13_months',        '13'),
  ('14_months',        '14'),
  ('transport_means',  'Company transport means'),
  ('fixed_housing',    'Fixed housing allowance'),
  ('housing_provision','Housing provided'),
  ('reimbursement_actual_costs',    'Reimbursement of actual costs');
-- 8) Translations for those new items
INSERT INTO solution_quiz_question_items_translate (itemCode, itemValue, languageId)
VALUES
  -- months
  ('12_months',    '12',                     1),
  ('12_months',    '12',                     2),
  
  ('13_months',    '13',                     1),
  ('13_months',    '13',                     2),
  
  ('14_months',    '14',                     1),
  ('14_months',    '14',                     2),
  
  
  -- transport
  ('transport_means',  'Company transport means',                               1),
  ('transport_means',  'Mise à disposition de moyens de transport (navette…)', 2),
  -- housing
  ('fixed_housing',    'Fixed housing allowance', 1),
  ('fixed_housing',    'Mise à disposition partielle ou totale d''un logement',2),
  
  ('housing_provision','Housing provided',                                     1),
  ('housing_provision','Mise à disposition partielle ou totale d\'un logement',2),

  -- reimbursement
  ('reimbursement_actual_costs',    'Reimbursement of actual costs',          1),
  ('reimbursement_actual_costs',    'Remboursement des frais réels',          2),
  ('commercial', 'Commercial staff', 1),
  ('commercial', 'Commercial', 2);
  
-- 9) Link items to Quiz 5 que stions (ordered Q1 → Q19)
INSERT INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther)
VALUES
  -- Q5-FSM-1
  ('12_months',     'Q5-FSM-1',  NULL, 0),
  ('13_months',     'Q5-FSM-1',  NULL, 0),
  ('14_months',     'Q5-FSM-1',  NULL, 0),
  ('other-please-specify',  'Q5-FSM-1',  NULL, 1),
  -- Q5-TFC-2
  ('yes',           'Q5-TFC-2',  NULL, 0),
  ('no',            'Q5-TFC-2',  NULL, 0),
  -- Q5-TFC-3
  ('executives',          'Q5-TFC-3', 'yes', 0),
  ('middle_managers',     'Q5-TFC-3', 'yes', 0),
  ('managers',            'Q5-TFC-3', 'yes', 0),
  ('commercial',          'Q5-TFC-3', 'yes', 0),
  ('professionals',       'Q5-TFC-3', 'yes', 0),
  ('support_tech',        'Q5-TFC-3', 'yes', 0),
  ('support_professional','Q5-TFC-3', 'yes', 0),
  ('labor',               'Q5-TFC-3', 'yes', 0),
  -- Q5-TAD-4
  ('yes',           'Q5-TAD-4',  NULL, 0),
  ('no',            'Q5-TAD-4',  NULL, 0),
  -- Q5-TAD-5
  ('executives',          'Q5-TAD-5', 'yes', 0),
  ('middle_managers',     'Q5-TAD-5', 'yes', 0),
  ('managers',            'Q5-TAD-5', 'yes', 0),
  ('commercial',          'Q5-TAD-5', 'yes', 0),
  ('professionals',       'Q5-TAD-5', 'yes', 0),
  ('support_tech',        'Q5-TAD-5', 'yes', 0),
  ('support_professional','Q5-TAD-5', 'yes', 0),
  ('labor',               'Q5-TAD-5', 'yes', 0),
  -- Q5-TAD-6
  ('fixed-amount',     'Q5-TAD-6', 'yes', 0),
  ('reimbursement_actual_costs',    'Q5-TAD-6', 'yes', 0),
  ('transport_means',  'Q5-TAD-6', 'yes', 0),
  -- Q5-TAD-7
  ('executives',          'Q5-TAD-7', 'fixed-amount', 1),
  ('middle_managers',     'Q5-TAD-7', 'fixed-amount', 1),
  ('managers',            'Q5-TAD-7', 'fixed-amount', 1),
  ('commercial',          'Q5-TAD-7', 'fixed-amount', 1),
  ('professionals',       'Q5-TAD-7', 'fixed-amount',1),
  ('support_tech',        'Q5-TAD-7', 'fixed-amount', 1),
  ('support_professional','Q5-TAD-7', 'fixed-amount', 1),
  ('labor',               'Q5-TAD-7', 'fixed-amount', 1),
  -- Q5-HAD-8
  ('yes',           'Q5-HAD-8',  NULL, 0),
  ('no',            'Q5-HAD-8',  NULL, 0),
  -- Q5-HAD-9
  ('executives',          'Q5-HAD-9', 'yes', 0),
  ('middle_managers',     'Q5-HAD-9', 'yes', 0),
  ('managers',            'Q5-HAD-9', 'yes', 0),
  ('commercial',          'Q5-HAD-9', 'yes', 0),
  ('professionals',       'Q5-HAD-9', 'yes', 0),
  ('support_tech',        'Q5-HAD-9', 'yes', 0),
  ('support_professional','Q5-HAD-9', 'yes', 0),
  ('labor',               'Q5-HAD-9', 'yes', 0),
  -- Q5-HAD-10
  ('fixed-amount',    'Q5-HAD-10', 'yes', 0),
  ('housing_provision','Q5-HAD-10', 'yes', 0),
  -- Q5-HAD-11
  ('executives',          'Q5-HAD-11', 'fixed-amount', 1),
  ('middle_managers',     'Q5-HAD-11', 'fixed-amount', 1),
  ('managers',            'Q5-HAD-11', 'fixed-amount', 1),
  ('commercial',          'Q5-HAD-11', 'fixed-amount', 1),
  ('professionals',       'Q5-HAD-11', 'fixed-amount', 1),
  ('support_tech',        'Q5-HAD-11', 'fixed-amount', 1),
  ('support_professional','Q5-HAD-11', 'fixed-amount', 1),
  ('labor',               'Q5-HAD-11', 'fixed-amount', 1),
  -- Q5-PLD-12
  ('yes',           'Q5-PLD-12', NULL, 0),
  ('no',            'Q5-PLD-12', NULL, 0),
  -- Q5-PLD-13
  ('executives',          'Q5-PLD-13', 'yes', 0),
  ('middle_managers',     'Q5-PLD-13', 'yes', 0),
  ('managers',            'Q5-PLD-13', 'yes', 0),
  ('commercial',          'Q5-PLD-13', 'yes', 0),
  ('professionals',       'Q5-PLD-13', 'yes', 0),
  ('support_tech',        'Q5-PLD-13', 'yes', 0),
  ('support_professional','Q5-PLD-13', 'yes', 0),
  ('labor',               'Q5-PLD-13', 'yes', 0),
  -- Q5-PLD-14
  ('executives',          'Q5-PLD-14', 'yes', 1),
  ('middle_managers',     'Q5-PLD-14', 'yes', 1),
  ('managers',            'Q5-PLD-14', 'yes', 1),
  ('commercial',          'Q5-PLD-14', 'yes', 1),
  ('professionals',       'Q5-PLD-14', 'yes', 1),
  ('support_tech',        'Q5-PLD-14', 'yes', 1),
  ('support_professional','Q5-PLD-14', 'yes', 1),
  ('labor',               'Q5-PLD-14', 'yes', 1),
  -- Q5-PLD-15
  ('executives',          'Q5-PLD-15', 'yes', 1),
  ('middle_managers',     'Q5-PLD-15', 'yes', 1),
  ('managers',            'Q5-PLD-15', 'yes', 1),
  ('commercial',          'Q5-PLD-15', 'yes',1),
  ('professionals',       'Q5-PLD-15', 'yes', 1),
  ('support_tech',        'Q5-PLD-15', 'yes', 1),
  ('support_professional','Q5-PLD-15', 'yes', 1),
  ('labor',               'Q5-PLD-15', 'yes', 1),
  -- Q5-SAI-16
  ('yes',           'Q5-SAI-16', NULL, 0),
  ('no',            'Q5-SAI-16', NULL, 0),
  -- Q5-SAI-17
  ('executives',          'Q5-SAI-17', 'yes', 0),
  ('middle_managers',     'Q5-SAI-17', 'yes', 0),
  ('managers',            'Q5-SAI-17', 'yes', 0),
  ('commercial',          'Q5-SAI-17', 'yes', 0),
  ('professionals',       'Q5-SAI-17', 'yes', 0),
  ('support_tech',        'Q5-SAI-17', 'yes', 0),
  ('support_professional','Q5-SAI-17', 'yes', 0),
  ('labor',               'Q5-SAI-17', 'yes', 0),
  -- Q5-SAI-18
  ('yes',           'Q5-SAI-18', NULL, 0),
  ('no',            'Q5-SAI-18', NULL, 0),
  -- Q5-SAI-19
  ('executives',          'Q5-SAI-19', 'yes', 0),
  ('middle_managers',     'Q5-SAI-19', 'yes', 0),
  ('managers',            'Q5-SAI-19', 'yes', 0),
  ('commercial',          'Q5-SAI-19', 'yes', 0),
  ('professionals',       'Q5-SAI-19', 'yes', 0),
  ('support_tech',        'Q5-SAI-19', 'yes', 0),
  ('support_professional','Q5-SAI-19', 'yes', 0),
  ('labor',               'Q5-SAI-19', 'yes', 0);