USE salarymarket;

--------------------------------------------------------------------------------
-- Quiz definition
--------------------------------------------------------------------------------
INSERT  INTO solution_quiz (id, quizCode, quiz_image, averagetime)
VALUES
  (12, 'quiz_12_Conges_Payes', 'Questionnaire 12.png', 20);

--------------------------------------------------------------------------------
-- Quiz translations (FR & EN)
--------------------------------------------------------------------------------
INSERT  INTO solution_quiz_translate (quizCode, title, description, short_description, languageId)
VALUES
  ('quiz_12_Conges_Payes',
   'Questionnaire 12 – Congés payés',
   'Enquête sur les politiques et pratiques relatives aux congés payés, report et autres congés payés.',
   'Étude sur les congés payés',
   2),
  ('quiz_12_Conges_Payes',
   'Quiz 12 – Paid Leave',
   'Survey of paid leave policies, unused leave treatment and other paid leave types.',
   'Survey on paid leave',
   1);

--------------------------------------------------------------------------------
-- Sections & translations
--------------------------------------------------------------------------------
INSERT  INTO solution_quiz_section (sectionCode, quizCode, section_order)
VALUES
  ('Eligibility',       'quiz_12_Conges_Payes', 1),
  ('Annual_Leave',      'quiz_12_Conges_Payes', 2),
  ('Unused_Leave',      'quiz_12_Conges_Payes', 3),
  ('Other_Paid_Leave',  'quiz_12_Conges_Payes', 4);

INSERT  INTO solution_quiz_section_translate (sectionCode, title, languageId)
VALUES
  ('Eligibility',      'Admissibilité', 2),
  ('Eligibility',      'Eligibility', 1),
  ('Annual_Leave',     'Nombre de jours de congés annuels', 2),
  ('Annual_Leave',     'Annual leave days', 1),
  ('Unused_Leave',     'Congés annuels inutilisés', 2),
  ('Unused_Leave',     'Unused annual leave', 1),
  ('Other_Paid_Leave', 'Autres types de congés payés', 2),
  ('Other_Paid_Leave', 'Other paid leave types', 1);

--------------------------------------------------------------------------------
-- Questions & translations
--------------------------------------------------------------------------------
INSERT  INTO solution_quiz_section_questions
  (questionCode, sectionCode, quizCode, idparent, type, question_order, echartType)
VALUES
  ('Q12-PL-1.1',   'Eligibility',       'quiz_12_Conges_Payes', NULL,        'CM_all',  1, 'Bar'),

  ('Q12-PL-2.1',   'Annual_Leave',      'quiz_12_Conges_Payes', NULL,        'CM',  2, 'Pie'),
  ('Q12-PL-2.3',   'Annual_Leave',      'quiz_12_Conges_Payes',  NULL,'CM',3, 'tab_num'),
  
   ('Q12-PL-2.3.1',   'Annual_Leave',      'quiz_12_Conges_Payes', NULL,'CU',4, 'Pie'),
   ('Q12-PL-2.3.2',   'Annual_Leave',      'quiz_12_Conges_Payes', NULL,'CU',5, 'Pie'),

  ('Q12-PL-2.3-Dir','Annual_Leave',     'quiz_12_Conges_Payes', 'Q12-PL-2.3.2','CM',6, 'tab_num'),
  ('Q12-PL-2.3-MM','Annual_Leave',      'quiz_12_Conges_Payes', 'Q12-PL-2.3.2','CM',7, 'tab_num'),
  ('Q12-PL-2.3-Mgr','Annual_Leave',     'quiz_12_Conges_Payes', 'Q12-PL-2.3.2','CM',8, 'tab_num'),
  ('Q12-PL-2.3-Sales','Annual_Leave',    'quiz_12_Conges_Payes', 'Q12-PL-2.3.2','CM',9, 'tab_num'),
  ('Q12-PL-2.3-Prof','Annual_Leave',     'quiz_12_Conges_Payes', 'Q12-PL-2.3.2','CM',10, 'tab_num'),
  ('Q12-PL-2.3-SupTech','Annual_Leave',   'quiz_12_Conges_Payes', 'Q12-PL-2.3.2','CM',11, 'tab_num'),
  ('Q12-PL-2.3-SupAdmin','Annual_Leave',  'quiz_12_Conges_Payes', 'Q12-PL-2.3.2','CM',12,'tab_num'),
  ('Q12-PL-2.3-Labor','Annual_Leave',     'quiz_12_Conges_Payes', 'Q12-PL-2.3.2','CM',13,'tab_num'),

  ('Q12-PL-2.4',   'Annual_Leave',      'quiz_12_Conges_Payes', NULL, 'CU', 14, 'Pie'),

  ('Q12-PL-3.1',   'Unused_Leave',      'quiz_12_Conges_Payes', NULL, 'CU', 15, 'Bar'),
  ('Q12-PL-3.2',   'Unused_Leave',      'quiz_12_Conges_Payes', NULL, 'CU', 16, 'Bar'),

  ('Q12-PL-5.1',   'Other_Paid_Leave',  'quiz_12_Conges_Payes', NULL, 'CM',17,'tab_num'),
  ('Q12-PL-5.4',   'Other_Paid_Leave',  'quiz_12_Conges_Payes', NULL,'CU', 18, 'Pie'),
  ('Q12-PL-5.7',   'Other_Paid_Leave',  'quiz_12_Conges_Payes', NULL, 'CU',19,'Pie');

INSERT  INTO solution_quiz_section_questions_translate (questionCode, title, languageId)
VALUES
  ('Q12-PL-1.1', 'Quels sont les catégories d''employés éligibles aux congés payés ?', 2),
  ('Q12-PL-1.1', 'Which employee categories are eligible for paid leave?', 1),

  ('Q12-PL-2.1', 'Quels sont les critères utilisés pour le calcul des congés payés annuels ?', 2),
  ('Q12-PL-2.1', 'Which criteria are used to calculate annual paid leave?', 1),
   ('Q12-PL-2.3.1','Accordez-vous des jours de congés payés supplémentaires en fonction de l''ancienneté ?',2),
('Q12-PL-2.3.1','Do you grant additional paid leave days based on seniority',1),
('Q12-PL-2.3.2','Le nombre de jours de congés annuels varie-t-il selon les catégories professionnelles ?',2),
('Q12-PL-2.3.2','Does the number of annual paid leave days differ by job category?',1),
('Q12-PL-2.3', 'Quel est le nombre de jours de congés annuels accordés à vos employés ?', 2),
('Q12-PL-2.3', 'What is the number of annual leave days granted to your employees?', 1),
('Q12-PL-2.3-Dir',  'Pour Dirigeants, Quel est le nombre de jours de congés annuels, en fonction de l''ancienneté?', 2),
('Q12-PL-2.3-Dir',  'For Executives: Number of annual leave days based on seniority', 1),
('Q12-PL-2.3-MM',   'Pour Middle Managers & Experts professionnels, Quel est le nombre de jours de congés annuels, en fonction de l''ancienneté?', 2),
('Q12-PL-2.3-MM',   'For Middle Managers & Professional Experts: Number of annual leave days based on seniority', 1),

('Q12-PL-2.3-Mgr',  'Pour Managers / Superviseurs, Quel est le nombre de jours de congés annuels, en fonction de l''ancienneté?', 2),
('Q12-PL-2.3-Mgr',  'For Managers / Supervisors: Number of annual leave days based on seniority', 1),

('Q12-PL-2.3-Sales','Pour Commercial / Force de vente, Quel est le nombre de jours de congés annuels, en fonction de l''ancienneté?', 2),
('Q12-PL-2.3-Sales','For Sales / Sales Force: Number of annual leave days based on seniority', 1),

('Q12-PL-2.3-Prof', 'Pour Professionnel / Ingénieur, Quel est le nombre de jours de congés annuels, en fonction de l''ancienneté?', 2),
('Q12-PL-2.3-Prof', 'For Professionals / Engineers: Number of annual leave days based on seniority', 1),

('Q12-PL-2.3-SupTech','Pour Support Technique, Quel est le nombre de jours de congés annuels, en fonction de l''ancienneté?', 2),
('Q12-PL-2.3-SupTech','For Technical Support: Number of annual leave days based on seniority', 1),

('Q12-PL-2.3-SupAdmin','Pour Support / Assistanat Administratif, Quel est le nombre de jours de congés annuels, en fonction de l''ancienneté?', 2),
('Q12-PL-2.3-SupAdmin','For Support / Administrative Assistants: Number of annual leave days based on seniority', 1),

('Q12-PL-2.3-Labor','Pour Main d''œuvre, Quel est le nombre de jours de congés annuels, en fonction de l''ancienneté?', 2),
('Q12-PL-2.3-Labor','For Labor / Workforce: Number of annual leave days based on seniority', 1),


  ('Q12-PL-2.4', 'Comment les provisions annuelles de congés payés, pour les employés ayant moins d''une année de service, sont-elles comptées ?', 2),
  ('Q12-PL-2.4', 'How are annual paid leave provisions counted for employees with less than one year of service?', 1),



  ('Q12-PL-3.1', 'Comment votre société indemnise-t-elle les employés pour les congés annuels inutilisés ?', 2),
  ('Q12-PL-3.1', 'How does your company compensate employees for unused annual leave?', 1),

  ('Q12-PL-3.2', 'Comment les congés annuels inutilisés sont-ils reportés ?', 2),
  ('Q12-PL-3.2', 'How are unused annual leave days carried forward?', 1),

  ('Q12-PL-5.1', 'Quels est le nombre de jours de congés payés que votre entreprise procure?', 2),
  ('Q12-PL-5.1', 'What is the number of paid vacation days that your company provides?', 1),


  ('Q12-PL-5.4', 'Le congé de maternité rémunéré est-il offert en pourcentage de salaire ou en complément des prestations du régime obligatoire/de la sécurité sociale ?', 2),
  ('Q12-PL-5.4', 'Is paid maternity leave offered as a percentage of salary or in addition to mandatory/social security benefits?', 1),

  ('Q12-PL-5.7', 'Le congé de paternité rémunéré est-il offert en pourcentage de salaire ou en complément des prestations du régime obligatoire/de la sécurité sociale ?', 2),
  ('Q12-PL-5.7', 'Is paid paternity leave offered as a percentage of salary or in addition to mandatory/social security benefits?', 1);

--------------------------------------------------------------------------------
-- Core response items (single/shared items, including after_* shared)
--------------------------------------------------------------------------------
INSERT  INTO solution_reponses_items (itemCode, itemName) VALUES
-- Criteria / general
('full_salary', 'Maintien intégral du salaire'),
('employer_topup', 'Complément employeur'),
('social_security_only', 'Versement limité à l\'indemnité de la sécurité sociale'),
('support_technical',"support technical"),
('criteria_none', 'No criteria'),
('criteria_seniority', 'Seniority'),
('criteria_category', 'Category'),


-- shared seniority steps (unique items used for all categories in 2.3)
('after_1_year', 'Après 1 an d''ancienneté'),
('after_2_years', 'Après 2 ans d''ancienneté'),
('after_3_years', 'Après 3 ans d''ancienneté'),
('after_4_years', 'Après 4 ans d''ancienneté'),
('after_5_years', 'Après 5 ans d''ancienneté'),
('after_10_years', 'Après 10 ans d''ancienneté'),
('after_15_years', 'Après 15 ans d''ancienneté'),
('after_20_years', 'Après 20 ans d''ancienneté'),

-- provisioning for <1 year
('prov_none', 'Not provided (0 days)'),
('prov_prorata', 'Prorated based on hire date'),


-- unused leave handling
('carry_over', 'Days are carried over to next year'),
('paid_out', 'Unused leave is paid out'),
('lost', 'Unused days are forfeited'),

-- carry rules
('carry_no_limit', 'Carried with no limitation'),
('carry_next_year', 'Limited to next year'),
('carry_max_years', 'Limited to a maximum number of years'),
('carry_percentage', 'Limited to a percentage of annual leave'),

-- maternity payment options
('maternity_full', 'Full salary'),
('maternity_percentage', 'Paid at a percentage of salary'),
('maternity_topup', 'Top-up to reach a certain percentage'),

-- paternity / leave-period policy options
('entire_leave_period', 'Toute la période de congé'),
('percentage_if_exceeds_legal', 'En pourcentage du salaire si le congé dépasse la base légale'),
('only_legal_period_if_exceeds', 'Seulement la période légale, en cas de dépassement de la période exigée par la loi'),


-- other paid leave types (for Q12-PL-5.1)
('employee_marriage', 'Mariage du collaborateur (ice)'),
('maternity', 'Maternité'),
('paternity', 'Paternité'),
('death_close_relative', 'Décès d''un parent proche (ex. conjoint, parents, beaux-parents, enfants)'),
('death_family_member', 'Décès d''un membre de la famille (ex. grands-parents, grands-parents par alliance, oncle, tante, etc.)'),
('leave_care_sick_parent', 'Congé pour s''occuper d''un parent proche atteint d''une maladie'),
('leave_care_sick_infant', 'Congé pour s''occuper d''un nourrisson malade'),
('child_circumcision', 'Circoncision d''un enfant'),
('child_marriage', 'Mariage d''un enfant'),
('eid_al_adha', 'Aïd el-Idha'),
('eid_al_fitr', 'Aïd el-Fitr'),
('relocation', 'Déménagement'),
('employee_birthday', 'Anniversaire de l''employé'),
('child_birthday', 'Anniversaire d''un enfant'),
('csr_leave', 'Congés de responsabilité sociale d''entreprise (RSE)');

--------------------------------------------------------------------------------
-- Translations for generic items (FR & EN)
--------------------------------------------------------------------------------
INSERT  INTO solution_quiz_question_items_translate (itemCode, itemValue, languageId) VALUES
-- criteria
('criteria_none','Aucun',2), ('criteria_none','None',1),
('criteria_seniority','Ancienneté',2), ('criteria_seniority','Seniority',1),
('criteria_category','Catégorie',2), ('criteria_category','Category',1),

('support_technical', 'Technical Support', 1),
('support_technical', 'Support technique', 2),
-- seniority steps (shared)
('after_1_year','Après 1 an d''ancienneté',2), ('after_1_year','After 1 year of seniority',1),
('after_2_years','Après 2 ans d''ancienneté',2), ('after_2_years','After 2 years of seniority',1),
('after_3_years','Après 3 ans d''ancienneté',2), ('after_3_years','After 3 years of seniority',1),
('after_4_years','Après 4 ans d''ancienneté',2), ('after_4_years','After 4 years of seniority',1),
('after_5_years','Après 5 ans d''ancienneté',2), ('after_5_years','After 5 years of seniority',1),
('after_10_years','Après 10 ans d''ancienneté',2), ('after_10_years','After 10 years of seniority',1),
('after_15_years','Après 15 ans d''ancienneté',2), ('after_15_years','After 15 years of seniority',1),
('after_20_years','Après 20 ans d''ancienneté',2), ('after_20_years','After 20 years of seniority',1),

-- provisions <1 year
('prov_none','Non fourni (0 jour)',2), ('prov_none','Not provided (0 days)',1),
('prov_prorata','Jours de congés annuels calculés au prorata, en fonction de la date d''embauche',2), ('prov_prorata','Prorated based on hire date',1),



-- unused leave handling
('carry_over','Les jours sont reportés d''une année sur l''autre',2), ('carry_over','Days are carried over to next year',1),
('paid_out','Les congés n''ayant pas été pris sont payés',2), ('paid_out','Unused leave is paid out',1),
('lost','Les jours inutilisés sont perdus (ni reportés ni remboursés)',2), ('lost','Unused days are forfeited',1),

-- carry rules
('carry_no_limit','Sans limitation',2), ('carry_no_limit','Carried with no limitation',1),
('carry_next_year','Limités à l''année suivante',2), ('carry_next_year','Limited to next year',1),
('carry_max_years','Limités à un nombre maximum d''années',2), ('carry_max_years','Limited to a maximum number of years',1),
('carry_percentage','Limités à un certain pourcentage de congés annuels',2), ('carry_percentage','Limited to a percentage of annual leave',1),

-- paternity/leave-period options
('entire_leave_period','Toute la période de congé',2), ('entire_leave_period','Entire leave period',1),
('percentage_if_exceeds_legal','En pourcentage du salaire si le congé dépasse la base légale',2), ('percentage_if_exceeds_legal','Percentage of salary if the leave exceeds the legally required period',1),
('only_legal_period_if_exceeds','Seulement la période légale, en cas de dépassement de la période exigée par la loi',2), ('only_legal_period_if_exceeds','Only the legal period if the leave exceeds the legally required duration',1),


-- other paid leave types translations
('employee_marriage','Mariage du collaborateur (ice)',2),('employee_marriage','Employee''s marriage',1),
('maternity','Maternité',2), ('maternity','Maternity',1),
('paternity','Paternité',2), ('paternity','Paternity',1),
('death_close_relative','Décès d''un parent proche (ex. conjoint, parents, beaux-parents, enfants)',2), ('death_close_relative','Death of a close relative (e.g., spouse, parents, parents-in-law, children)',1),
('death_family_member','Décès d''un membre de la famille (ex. grands-parents, grands-parents par alliance, oncle, tante, etc.)',2), ('death_family_member','Death of a family member (e.g., grandparents, grandparents-in-law, uncle, aunt, etc.)',1),
('leave_care_sick_parent','Congé pour s''occuper d''un parent proche atteint d''une maladie',2), ('leave_care_sick_parent','Leave to care for a sick close relative',1),
('leave_care_sick_infant','Congé pour s''occuper d''un nourrisson malade',2), ('leave_care_sick_infant','Leave to care for a sick infant',1),
('child_circumcision','Circoncision d''un enfant',2), ('child_circumcision','Child''s circumcision',1),
('child_marriage','Mariage d''un enfant',2), ('child_marriage','Child''s marriage',1),
('eid_al_adha','Aïd el-Idha',2), ('eid_al_adha','Eid al-Adha',1),
('eid_al_fitr','Aïd el-Fitr',2), ('eid_al_fitr','Eid al-Fitr',1),
('relocation','Déménagement',2), ('relocation','Relocation / Moving house',1),
('employee_birthday','Anniversaire de l''employé',2), ('employee_birthday','Employee''s birthday',1),
('child_birthday','Anniversaire d''un enfant',2), ('child_birthday','Child''s birthday',1),
('csr_leave','Congés de responsabilité sociale d''entreprise (RSE)',2), ('csr_leave','Corporate social responsibility (CSR) leave',1),

 ('full_salary', 'Maintien intégral du salaire', 2),
  ('full_salary', 'Full salary maintained', 1),

  ('employer_topup', 'Complément employeur', 2),
  ('employer_topup', 'Employer top-up', 1),

  ('social_security_only', 'Versement limité à l\'indemnité de la sécurité sociale', 2),
  ('social_security_only', 'Payment limited to social security allowance', 1);

--------------------------------------------------------------------------------
-- Link items to questions (question items)
-- For 2.3 we attach the SAME after_* items to each sub-question
--------------------------------------------------------------------------------

-- Q12-PL-1.1 categories (multi-select)
INSERT  INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('executives','Q12-PL-1.1', NULL, 0),
  ('middle_managers','Q12-PL-1.1', NULL, 0),
  ('managers','Q12-PL-1.1', NULL, 0),
  ('sales','Q12-PL-1.1', NULL, 0),
  ('professionals','Q12-PL-1.1', NULL, 0),
  ('support_technical','Q12-PL-1.1', NULL, 0),
  ('support_professional','Q12-PL-1.1', NULL, 0),
  ('labor','Q12-PL-1.1', NULL, 0);

-- Q12-PL-2.1 criteria (multi)
INSERT  INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('criteria_none','Q12-PL-2.1', NULL, 0),
  ('criteria_seniority','Q12-PL-2.1', NULL, 0),
  ('criteria_category','Q12-PL-2.1', NULL, 0),
  ('other-please-specify','Q12-PL-2.1', NULL, 1);

-- Q12-PL-2.3 Table cells: attach shared after_* items to each sub-question
INSERT  INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  -- Dirigeants

 ('executives','Q12-PL-2.3', NULL, 1),
  ('middle_managers','Q12-PL-2.3', NULL, 1),
  ('managers','Q12-PL-2.3', NULL, 1),
  ('sales','Q12-PL-2.3', NULL, 1),
  ('professionals','Q12-PL-2.3', NULL, 1),
  ('support_technical','Q12-PL-2.3', NULL, 1),
  ('support_professional','Q12-PL-2.3', NULL, 1),
  ('labor','Q12-PL-2.3', NULL, 1),


   ('yes','Q12-PL-2.3.1', NULL, 0),
   ('no','Q12-PL-2.3.1', NULL, 0),
  
   ('yes','Q12-PL-2.3.2', NULL, 0),
   ('no','Q12-PL-2.3.2', NULL, 0),
  
  ('after_1_year','Q12-PL-2.3-Dir', 'yes', 1),
  ('after_2_years','Q12-PL-2.3-Dir',  'yes', 1),
  ('after_3_years','Q12-PL-2.3-Dir',  'yes', 1),
  ('after_4_years','Q12-PL-2.3-Dir',  'yes', 1),
  ('after_5_years','Q12-PL-2.3-Dir',  'yes', 1),
  ('after_10_years','Q12-PL-2.3-Dir', 'yes', 1),
  ('after_15_years','Q12-PL-2.3-Dir',  'yes', 1),
  ('after_20_years','Q12-PL-2.3-Dir', 'yes', 1),

  -- Middle Managers & Experts
  ('after_1_year','Q12-PL-2.3-MM', 'yes', 1),
  ('after_2_years','Q12-PL-2.3-MM',  'yes', 1),
  ('after_3_years','Q12-PL-2.3-MM',  'yes', 1),
  ('after_4_years','Q12-PL-2.3-MM',  'yes', 1),
  ('after_5_years','Q12-PL-2.3-MM',  'yes', 1),
  ('after_10_years','Q12-PL-2.3-MM', 'yes', 1),
  ('after_15_years','Q12-PL-2.3-MM',  'yes', 1),
  ('after_20_years','Q12-PL-2.3-MM', 'yes', 1),

  -- Managers
  ('after_1_year','Q12-PL-2.3-Mgr', 'yes', 1),
  ('after_2_years','Q12-PL-2.3-Mgr',  'yes', 1),
  ('after_3_years','Q12-PL-2.3-Mgr',  'yes',1),
  ('after_4_years','Q12-PL-2.3-Mgr', 'yes', 1),
  ('after_5_years','Q12-PL-2.3-Mgr', 'yes', 1),
  ('after_10_years','Q12-PL-2.3-Mgr','yes', 1),
  ('after_15_years','Q12-PL-2.3-Mgr',  'yes', 1),
  ('after_20_years','Q12-PL-2.3-Mgr', 'yes', 1),

  -- Sales
  ('after_1_year','Q12-PL-2.3-Sales', 'yes', 1),
  ('after_2_years','Q12-PL-2.3-Sales',  'yes', 1),
  ('after_3_years','Q12-PL-2.3-Sales',  'yes', 1),
  ('after_4_years','Q12-PL-2.3-Sales', 'yes', 1),
  ('after_5_years','Q12-PL-2.3-Sales',  'yes', 1),
  ('after_10_years','Q12-PL-2.3-Sales', 'yes', 1),
  ('after_15_years','Q12-PL-2.3-Sales', 'yes', 1),
  ('after_20_years','Q12-PL-2.3-Sales',  'yes', 1),

  -- Professionals
  ('after_1_year','Q12-PL-2.3-Prof',  'yes', 1),
  ('after_2_years','Q12-PL-2.3-Prof',  'yes', 1),
  ('after_3_years','Q12-PL-2.3-Prof', 'yes', 1),
  ('after_4_years','Q12-PL-2.3-Prof', 'yes', 1),
  ('after_5_years','Q12-PL-2.3-Prof',  'yes', 1),
  ('after_10_years','Q12-PL-2.3-Prof', 'yes', 1),
  ('after_15_years','Q12-PL-2.3-Prof',  'yes', 1),
  ('after_20_years','Q12-PL-2.3-Prof',  'yes', 1),

  -- Support Technical
  ('after_1_year','Q12-PL-2.3-SupTech',  'yes', 1),
  ('after_2_years','Q12-PL-2.3-SupTech',  'yes', 1),
  ('after_3_years','Q12-PL-2.3-SupTech',  'yes', 1),
  ('after_4_years','Q12-PL-2.3-SupTech', 'yes', 1),
  ('after_5_years','Q12-PL-2.3-SupTech',  'yes', 1),
  ('after_10_years','Q12-PL-2.3-SupTech',  'yes', 1),
  ('after_15_years','Q12-PL-2.3-SupTech',  'yes', 1),
  ('after_20_years','Q12-PL-2.3-SupTech',  'yes', 1),

  -- Support Admin
  ('after_1_year','Q12-PL-2.3-SupAdmin', 'yes', 1),
  ('after_2_years','Q12-PL-2.3-SupAdmin',  'yes', 1),
  ('after_3_years','Q12-PL-2.3-SupAdmin',  'yes', 1),
  ('after_4_years','Q12-PL-2.3-SupAdmin',  'yes', 1),
  ('after_5_years','Q12-PL-2.3-SupAdmin', 'yes', 1),
  ('after_10_years','Q12-PL-2.3-SupAdmin',  'yes', 1),
  ('after_15_years','Q12-PL-2.3-SupAdmin',  'yes', 1),
  ('after_20_years','Q12-PL-2.3-SupAdmin', 'yes', 1),

  -- Labor
  ('after_1_year','Q12-PL-2.3-Labor',  'yes', 1),
  ('after_2_years','Q12-PL-2.3-Labor', 'yes', 1),
  ('after_3_years','Q12-PL-2.3-Labor', 'yes', 1),
  ('after_4_years','Q12-PL-2.3-Labor', 'yes', 1),
  ('after_5_years','Q12-PL-2.3-Labor', 'yes', 1),
  ('after_10_years','Q12-PL-2.3-Labor', 'yes', 1),
  ('after_15_years','Q12-PL-2.3-Labor', 'yes', 1),
  ('after_20_years','Q12-PL-2.3-Labor',  'yes', 1);

-- Q12-PL-2.4 (<1 year provisions)
INSERT  INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('prov_none','Q12-PL-2.4', NULL, 0),
  ('prov_prorata','Q12-PL-2.4', NULL, 0),
  ('other-please-specify','Q12-PL-2.4', NULL, 1);

-- Q12-PL-2.5 short periods
INSERT  INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('yes','Q12-PL-2.5', NULL, 0),
  ('no','Q12-PL-2.5', NULL, 0);

-- Q12-PL-3.1 unused leave compensation
INSERT  INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('carry_over','Q12-PL-3.1', NULL, 0),
  ('paid_out','Q12-PL-3.1', NULL, 0),
  ('lost','Q12-PL-3.1', NULL, 0);

-- Q12-PL-3.2 how carried over
INSERT  INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('carry_no_limit','Q12-PL-3.2', NULL, 0),
  ('carry_next_year','Q12-PL-3.2', NULL, 0),
  ('carry_max_years','Q12-PL-3.2', NULL, 0),
  ('carry_percentage','Q12-PL-3.2', NULL, 0);

-- Q12-PL-5.1 other paid leave types (table)


INSERT  INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('employee_marriage','Q12-PL-5.1', NULL, 1),
  ('maternity','Q12-PL-5.1', NULL, 1),
  ('paternity','Q12-PL-5.1', NULL,1),
  ('death_close_relative','Q12-PL-5.1', NULL, 1),
  ('death_family_member','Q12-PL-5.1', NULL, 1),
  ('leave_care_sick_parent','Q12-PL-5.1', NULL, 1),
  ('leave_care_sick_infant','Q12-PL-5.1', NULL, 1),
  ('child_circumcision','Q12-PL-5.1', NULL, 1),
  ('child_marriage','Q12-PL-5.1', NULL, 1),
  ('eid_al_adha','Q12-PL-5.1', NULL, 1),
  ('eid_al_fitr','Q12-PL-5.1', NULL, 1),
  ('relocation','Q12-PL-5.1', NULL, 1),
  ('employee_birthday','Q12-PL-5.1', NULL, 1),
  ('child_birthday','Q12-PL-5.1', NULL, 1),
  ('csr_leave','Q12-PL-5.1', NULL, 1);

-- Q12-PL-5.4 maternity remuneration
INSERT  INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
('full_salary','Q12-PL-5.4', NULL, 0),
('employer_topup','Q12-PL-5.4', NULL, 0),
('social_security_only','Q12-PL-5.4', NULL, 0),
('other-please-specify','Q12-PL-5.4', NULL, 1);

-- Q12-PL-5.7 paternity leave options (table cells)
INSERT  INTO solution_quiz_section_questions_items (itemCode, questionCode, itemParentId, isOther) VALUES
  ('full_salary','Q12-PL-5.7', NULL, 0),
  ('employer_topup','Q12-PL-5.7', NULL, 0),
  ('social_security_only','Q12-PL-5.7', NULL, 0),
  ('other-please-specify','Q12-PL-5.7', NULL, 1);
