-- 1️ Add 'matricule'
ALTER TABLE solution_reports_config_gaps MODIFY category ENUM('market', 'personalized', 'matricule') NOT NULL;
ALTER TABLE solution_report_criterias MODIFY category ENUM('market', 'personalized', 'matricule') NOT NULL;
ALTER TABLE solution_report_criterias_config MODIFY category ENUM('market', 'personalized', 'matricule') NOT NULL;
ALTER TABLE solution_report_charts MODIFY category ENUM('market', 'personalized', 'matricule') NOT NULL;
ALTER TABLE solution_report_criterias_charts MODIFY category ENUM('market', 'personalized', 'matricule') NOT NULL;
ALTER TABLE company_reports MODIFY category ENUM('market', 'personalized', 'matricule') NOT NULL;

-- 2️ INSERTS WITH category = 'matricule'

-- solution_reports_config_gaps
INSERT INTO solution_reports_config_gaps (subscription_code, category, gap) VALUES 
('advanced', 'matricule', true),
('on_the_menu', 'matricule', true);

-- solution_report_criterias
INSERT INTO solution_report_criterias (subscription_code, category, report_criterias) VALUES
-- On The Menu / matricule
('on_the_menu', 'matricule', 'on_the_menu-function_code-subfunction_code-collaborative_path-grade'),

-- Advanced / matricule
('advanced', 'matricule', 'advanced-function_code-subfunction_code-collaborative_path-grade');

-- solution_report_criterias_config
INSERT INTO solution_report_criterias_config 
  (subscription_code, category, report_criterias, criteria) 
VALUES
-- On The Menu / matricule
('on_the_menu', 'matricule', 'on_the_menu-function_code-subfunction_code-collaborative_path-grade', 'function_code'),
('on_the_menu', 'matricule', 'on_the_menu-function_code-subfunction_code-collaborative_path-grade', 'subfunction_code'),
('on_the_menu', 'matricule', 'on_the_menu-function_code-subfunction_code-collaborative_path-grade', 'collaborative_path'),
('on_the_menu', 'matricule', 'on_the_menu-function_code-subfunction_code-collaborative_path-grade', 'grade'),

-- Advanced / matricule
('advanced', 'matricule', 'advanced-function_code-subfunction_code-collaborative_path-grade', 'function_code'),
('advanced', 'matricule', 'advanced-function_code-subfunction_code-collaborative_path-grade', 'subfunction_code'),
('advanced', 'matricule', 'advanced-function_code-subfunction_code-collaborative_path-grade', 'collaborative_path'),
('advanced', 'matricule', 'advanced-function_code-subfunction_code-collaborative_path-grade', 'grade');

-- solution_report_charts
INSERT INTO solution_report_charts (subscription_code, category, report_chart) VALUES
-- On The Menu / matricule
('on_the_menu', 'matricule', 'gap_general'),
('on_the_menu', 'matricule', 'general_internal_gap_fixed'),

-- Advanced / matricule
('advanced', 'matricule', 'gap_general'),
('advanced', 'matricule', 'general_internal_gap_fixed');

-- solution_report_criterias_charts
INSERT INTO solution_report_criterias_charts 
(subscription_code, category, report_criterias, criteria) VALUES
-- On The Menu / matricule
('on_the_menu', 'matricule', 'on_the_menu-function_code-subfunction_code-collaborative_path-grade', 'repartition_gap'),
('on_the_menu', 'matricule', 'on_the_menu-function_code-subfunction_code-collaborative_path-grade', 'repartition_data_bf'),
('on_the_menu', 'matricule', 'on_the_menu-function_code-subfunction_code-collaborative_path-grade', 'repartition_data_bt'),

-- Advanced / matricule  
('advanced', 'matricule', 'advanced-function_code-subfunction_code-collaborative_path-grade','repartition_gap'),
('advanced', 'matricule', 'advanced-function_code-subfunction_code-collaborative_path-grade','repartition_data_bf'),
('advanced', 'matricule', 'advanced-function_code-subfunction_code-collaborative_path-grade','repartition_data_bt');
