use socle;

-- initialise languages
INSERT INTO languages (id, language, tag) VALUES 
(1, 'English', 'en'),
(2, 'French', 'fr');

-- initialise language solution
INSERT INTO solution_languages (id, active, defaultLanguage, languagesId) VALUES 
(1, 'false', 0, '1'),
(2, 'true', 1, '2');

INSERT INTO solution_menu (id, menuCode, menuLibelle, parentMenu, type) VALUES
-- Home Section
(1, 'home', 'Home',NULL, 'menu'),
(2, 'home_administration', 'Administration', 'home', 'subMenu'),
(3, 'home_administration_clients', ' Number  of Clients ', 'home_administration', 'widget'),
(4, 'home_administration_secteurs', ' Clients per Sector', 'home_administration', 'widget'),
(5, 'home_administration_subscription', 'Subscription  per clients ', 'home_administration', 'widget'), 
(6, 'home_administrationemployees_per_region', 'Employees per Region', 'home_administration', 'widget'),
(7, 'home_indicators', 'Indicators','home', 'subMenu'),
(8, 'home_indicateurs_number_of_employees', 'Number of Employees', 'home_indicators', 'widget'),
(9, 'home_indicateurs_payroll', 'Payroll','home_indicators', 'widget'),
(10, 'home_indicateurs_average_salaries_by_career_path', 'Average Salaries by Career Path', 'home_indicators', 'widget'),
(11, 'home_indicateurs_supervision_rate', 'Supervision Rate', 'home_indicators', 'widget'),

-- Company Section
(12, 'company_compensation', 'Company Compensation', NULL, 'menu'),

-- Quiz Section
(13, 'company_quiz', 'HR Policy and Practices', NULL, 'menu'),
(14, 'quiz_sector', 'Quiz by Sector','company_quiz', 'option'),
(15, 'quiz_market', 'Quiz by Market', 'company_quiz', 'option'),

-- Report Section
(16, 'report', 'Report', NULL, 'menu'),

-- My Company Section
(17, 'myCompany', 'My Company', NULL, 'menu'),
(18, 'myCompany_informations', 'Information', 'myCompany', 'menu'),
(19, 'myCompany_users', 'Users', 'myCompany', 'menu'),
(20, 'myCompany_entities', 'Entities', 'myCompany', 'menu'),
(21, 'myCompany_profiles', 'Profiles','myCompany', 'menu'),
(22, 'myCompany_configuration', 'Configuration', 'myCompany', 'menu'),
(23, 'myCompany_settings', 'Settings', 'myCompany', 'menu'),
(24, 'myCompany_settings_language', 'Language', 'myCompany_settings', 'subMenu'),

-- My Clients Section
(25, 'myClients', 'My Clients', NULL, 'menu'),
(26, 'myClients_clients', 'Clients', 'myClients', 'menu'),
(27, 'client_informations', 'Information','myClients_clients', 'subMenu'),
(28, 'client_users', 'Users', 'myClients_clients', 'subMenu'),
(29, 'client_entities', 'Entities', 'myClients_clients', 'subMenu'),
(30, 'client_profiles', 'Profiles', 'myClients_clients', 'subMenu'),
(31, 'client_configuration', 'Configuration', 'myClients_clients', 'subMenu'),
(32, 'myClients_prospection', 'Prospecting', 'myClients', 'menu'),

-- Administration Section
(33, 'administration', 'Administration', NULL, 'menu'),
(34, 'administration_settings', 'Settings', 'administration', 'menu'),
(35, 'administration_settings_language', 'Language', 'administration_settings', 'subMenu'),
(36, 'administration_settings_country', 'Country', 'administration_settings', 'subMenu'),
(37, 'administration_settings_business-sector', 'Business Sector', 'administration_settings', 'subMenu'),
(38, 'administration_settings_turnover', 'Turnover', 'administration_settings', 'subMenu'),
(39, 'administration_settings_geographic-extent', 'Geographic Extent', 'administration_settings', 'subMenu'),
(40, 'administration_settings_company-size', 'Company Size', 'administration_settings', 'subMenu'),
(41, 'administration_settings_value-chain', 'Value Chain','administration_settings', 'subMenu'),
(42, 'administration_entities', 'Entities', 'administration', 'menu'),
(43, 'administration_subscription', 'Subscription', 'administration', 'menu');-- changer l'ordre

INSERT INTO solution_subscription (id,code,type)
VALUES 
  (1,'on_The_menu','On The Menu'),
  (2,'essential','Essential'),
  (3,'advanced','Advanced');
  

-- Insert all rights for modules 
INSERT INTO solution_menu_rights (id, code, action, menuCode) VALUES
-- Compensation
(1, 'compensation_import', 'Import', 'company_compensation'),
(2, 'compensation_search', 'Search', 'company_compensation'),
(3, 'compensation_export', 'Export', 'company_compensation'),
(4, 'compensation_create', 'Create', 'company_compensation'),
(5, 'compensation_delete', 'Delete', 'company_compensation'),
(6, 'compensation_upload', 'Upload', 'company_compensation'),

-- HR Policy and Practices
(7, 'quiz_Submit', 'Submit', 'company_quiz'),
(8, 'quiz_View', 'View', 'company_quiz'),

-- Report 
(9,'report_create', 'Create', 'report'),
(10,'report_View', 'View', 'report'),
(11,'report_update', 'Update', 'report'),
(12,'report_delete', 'Delete', 'report'),
(13,'report_upload', 'Upload', 'report'),

-- Informations company
(14, 'company_Informations_update', 'Update', 'myCompany_informations'),

-- Users company
(15, 'company_user_create', 'Create', 'myCompany_users'),
(16, 'company_user_update', 'Update', 'myCompany_users'),
(17, 'company_user_delete', 'Delete', 'myCompany_users'),
(18, 'company_user_desactivate', 'Desactivate', 'myCompany_users'),
(19, 'company_user_activate', 'Activate', 'myCompany_users'),
(20, 'company_user_activity', 'Activity', 'myCompany_users'),

-- Entities company
(21, 'company_entites_Create', 'Create', 'myCompany_entities'),
(22, 'company_entites_update', 'Update', 'myCompany_entities'),
(23, 'company_entites_delete', 'Delete', 'myCompany_entities'),

-- Profiles company
(24, 'company_profil_Create', 'Create', 'myCompany_profiles'),
(25, 'company_profil_update', 'Update', 'myCompany_profiles'),
(26, 'company_profil_delete', 'Delete', 'myCompany_profiles'),

-- Languages company
(27, 'company_language_activate', 'Activate', 'myCompany_settings_language');

INSERT INTO solution_subscription_menu (id, subscriptionCode, menuCode, state) VALUES
  (1, 'on_The_menu', 'home', 1),
  (2, 'on_The_menu', 'home_indicators', 1),
  (3, 'on_The_menu', 'home_indicateurs_number_of_employees', 1),
  (4, 'on_The_menu', 'home_indicateurs_payroll', 1),
  (5, 'on_The_menu', 'home_indicateurs_average_salaries_by_career_path', 1),
  (6, 'on_The_menu', 'home_indicateurs_supervision_rate', 1),
  (7, 'on_The_menu', 'company_compensation', 1),
  (8, 'on_The_menu', 'company_quiz', 1),
  (9, 'on_The_menu', 'quiz_sector', 1),
  (10, 'on_The_menu', 'quiz_market', 1),
  (11, 'on_The_menu', 'report', 1),
  (12, 'on_The_menu', 'myCompany', 1),
  (13, 'on_The_menu', 'myCompany_informations', 1),
  (14, 'on_The_menu', 'myCompany_users', 1),
  (15, 'on_The_menu', 'myCompany_entities', 1),
  (16, 'on_The_menu', 'myCompany_profiles', 1),
  (17, 'on_The_menu', 'myCompany_configuration', 1),
  (18, 'on_The_menu', 'myCompany_settings', 1),
  (19, 'on_The_menu', 'myCompany_settings_language', 1);
  
INSERT INTO solution_subscription_menu (id, subscriptionCode, menuCode, state) VALUES
(20,'essential', 'home', 1), -- Menu: Company
(21,'essential', 'report', 1), -- Menu: Company
(22,'essential', 'myCompany', 1), -- Menu: Company
(23,'essential', 'myCompany_informations', 1), -- SubMenu: Informations
(24,'essential', 'myCompany_users', 1), -- SubMenu: Users
(25,'essential', 'myCompany_entities', 1), -- SubMenu: Entities
(26,'essential', 'myCompany_profiles', 1), -- SubMenu: Profiles
(27,'essential', 'myCompany_configuration', 1), -- SubMenu: Configuration
(28,'essential', 'myCompany_settings', 1), -- SubMenu: Settings
(29,'essential', 'myCompany_settings_language', 1); -- SubMenu: Language

INSERT INTO solution_subscription_menu (id, subscriptionCode, menuCode, state) VALUES
(30,'advanced', 'home', 1), -- SubMenu: Indicators
(31,'advanced', 'home_indicators', 1), -- SubMenu: Indicators
(32,'advanced', 'home_indicateurs_number_of_employees', 1), -- Widget: Number of employees
(33,'advanced', 'home_indicateurs_payroll', 1), -- Widget: Payroll
(34,'advanced', 'home_indicateurs_average_salaries_by_career_path', 1), -- Widget: Average salaries by career path
(35,'advanced', 'home_indicateurs_supervision_rate', 1), -- Widget: Management rate
(36,'advanced', 'company_compensation', 1), -- Menu: Compensation
(37,'advanced', 'company_quiz', 1), -- Menu: HR Policy and Practices
(38,'advanced', 'quiz_sector', 1), -- Option: HRPP by Sector
(39,'advanced', 'quiz_market', 1), -- Option: Quiz by Market
(40,'advanced', 'report', 1), -- Menu: Reports
(41,'advanced', 'myCompany', 1), -- Menu: Company
(42,'advanced', 'myCompany_informations', 1), -- SubMenu: Informations
(43,'advanced', 'myCompany_users', 1), -- SubMenu: Users
(44,'advanced', 'myCompany_entities', 1), -- SubMenu: Entities
(45,'advanced', 'myCompany_profiles', 1), -- SubMenu: Profiles
(46,'advanced', 'myCompany_configuration', 1), -- SubMenu: Configuration
(47,'advanced', 'myCompany_settings', 1), -- SubMenu: Settings
(48,'advanced', 'myCompany_settings_language', 1); -- SubMenu: Language


INSERT INTO solution_subscription_menu_rights (id, subscriptionCode, menuCode, solution_menu_rights_code) VALUES
-- on the menu 
-- Compensation
(1, 'on_The_menu','company_compensation','compensation_import'), 
(2, 'on_The_menu','company_compensation','compensation_search'),
(3, 'on_The_menu','company_compensation','compensation_export'),
(4, 'on_The_menu','company_compensation','compensation_create'),
(5, 'on_The_menu','company_compensation','compensation_delete'),
(6, 'on_The_menu','company_compensation','compensation_upload'),
-- quiz
(7, 'on_The_menu','company_quiz', 'quiz_View'),
-- report 
(8,'on_The_menu','report','report_create'),
(9,'on_The_menu','report','report_View'),
(10,'on_The_menu','report','report_update'),
(11,'on_The_menu','report','report_delete'),
(12,'on_The_menu','report','report_upload'),
-- Informations
(13, 'on_The_menu','myCompany_informations', 'company_Informations_update'), 
-- Users
(14,'on_The_menu','myCompany_users', 'company_user_create'),
(15,'on_The_menu','myCompany_users', 'company_user_update'),
(16,'on_The_menu','myCompany_users', 'company_user_delete'), 
(17,'on_The_menu','myCompany_users', 'company_user_desactivate'),
(18,'on_The_menu','myCompany_users', 'company_user_activate'),
(19,'on_The_menu','myCompany_users', 'company_user_activity'),
-- entities
(20,'on_The_menu','myCompany_entities','company_entites_Create'), 
(21,'on_The_menu','myCompany_entities','company_entites_update'),  
(22,'on_The_menu','myCompany_entities','company_entites_delete'), 
-- profiles
(23,'on_The_menu','myCompany_profiles','company_profil_Create'),  
(24,'on_The_menu','myCompany_profiles','company_profil_update'),  
(25,'on_The_menu','myCompany_profiles','company_profil_delete'),  
-- languages
(26, 'on_The_menu','myCompany_settings_language', 'company_language_activate'),

-- Essential 
-- report
(27, 'essential','report', 'report_create'), 
(28, 'essential','report', 'report_View'), 
(29, 'essential','report', 'report_update'), 
(30, 'essential','report', 'report_delete'), 
-- Informations
(31, 'essential','myCompany_informations', 'company_Informations_update'), 
-- Users
(32,'essential','myCompany_users', 'company_user_create'),
(33,'essential','myCompany_users', 'company_user_update'),
(34,'essential','myCompany_users', 'company_user_delete'), 
(35,'essential','myCompany_users', 'company_user_desactivate'),
(36,'essential','myCompany_users', 'company_user_activate'),
(37,'essential','myCompany_users', 'company_user_activity'), 
-- entities
(38,'essential','myCompany_entities','company_entites_Create'), 
(39,'essential','myCompany_entities','company_entites_update'),  
(40,'essential','myCompany_entities','company_entites_delete'), 
-- profiles
(41,'essential','myCompany_profiles','company_profil_Create'),  
(42,'essential','myCompany_profiles','company_profil_update'),  
(43,'essential','myCompany_profiles','company_profil_delete'),  
-- languages
(44, 'essential','myCompany_settings_language', 'company_language_activate'),
 
-- Advanced 
-- Compensation
(45, 'advanced','company_compensation','compensation_import'), 
(46, 'advanced','company_compensation','compensation_search'),
(47, 'advanced','company_compensation','compensation_export'),
(48, 'advanced','company_compensation','compensation_create'),
(49, 'advanced','company_compensation','compensation_delete'),
(50, 'advanced','company_compensation','compensation_upload'),
-- quiz
(51, 'advanced','company_quiz', 'quiz_View'),
-- report
(52, 'advanced','report', 'report_create'), 
(53, 'advanced','report', 'report_View'), 
(54, 'advanced','report', 'report_update'), 
(55, 'advanced','report', 'report_delete'), 
(56, 'advanced','report', 'report_upload'),
-- Informations
(57, 'advanced','myCompany_informations', 'company_Informations_update'), 
-- Users
(58,'advanced','myCompany_users', 'company_user_create'),
(59,'advanced','myCompany_users', 'company_user_update'),
(60,'advanced','myCompany_users', 'company_user_delete'), 
(61,'advanced','myCompany_users', 'company_user_desactivate'),
(62,'advanced','myCompany_users', 'company_user_activate'),
(63,'advanced','myCompany_users', 'company_user_activity'),
-- entities
(64,'advanced','myCompany_entities','company_entites_Create'), 
(65,'advanced','myCompany_entities','company_entites_update'),  
(66,'advanced','myCompany_entities','company_entites_delete'),
-- profiles
(67,'advanced','myCompany_profiles','company_profil_Create'),  
(68,'advanced','myCompany_profiles','company_profil_update'),  
(69,'advanced','myCompany_profiles','company_profil_delete'),  
-- languages
(70, 'advanced','myCompany_settings_language', 'company_language_activate');

-- Inserting parent settings into solution_setting
INSERT INTO solution_setting (id, label, type) VALUES
(1, 'Chiffre d’affaires', 'ca'),
(2, 'Étendue géographique', 'geographic_extent'),
(3, 'Chaîne de valeur', 'value_chain'),
(4, 'Taille de l’entreprise', 'company_size'),
(5, 'Secteur d’activité', 'business_sector'),
(6, 'Pays', 'country');
-- Inserting items for all settings with explicit IDs
INSERT INTO solution_setting_item (id, label, code, settingId) VALUES
-- Items for 'Chiffre d’affaires' (ID: 1)
(1, '1 - 10000', 'CA001', 1),
(2, '10000 - 100000', 'CA002', 1),
(3, '100000 - 500000', 'CA003', 1),
(4, '500000 - 1000000', 'CA004', 1),
(5, 'plus de 100000', 'CA005', 1),
-- Items for 'Étendue géographique' (ID: 2)
(6, 'Présent sur un seul pays', 'GE001', 2),
(7, 'Présent sur plusieurs pays d’une même région', 'GE002', 2),
(8, 'Présent sur plusieurs pays de deux continents différents', 'GE003', 2),
(9, 'Présent sur plus de deux continents', 'GE004', 2),
-- Items for 'Chaîne de valeur' (ID: 3)
(10, 'Contrôle total de toute la chaine de valeur', 'VC001', 3),
(11, 'Contrôle partiel de la chaine de valeur', 'VC002', 3),
-- Items for 'Taille de l’entreprise' (ID: 4)
(12, 'Moins de 10', 'CS001', 4),
(13, 'Entre 11 et 20', 'CS002', 4),
(14, 'Entre 21 et 30', 'CS003', 4),
(15, 'Entre 31 et 50', 'CS004', 4),
(16, 'Entre 51 et 100', 'CS005', 4),
(17, 'Entre 101 et 300', 'CS006', 4),
(18, 'Entre 301 et 500', 'CS007', 4),
(19, 'Entre 501 et 1000', 'CS008', 4),
(20, 'Entre 1001 et 2000', 'CS009', 4),
(21, 'Plus de 2001', 'CS010', 4),
-- Items for 'Secteur d’activité' (ID: 5)
(22, 'IT', 'BS001', 5),
(23, 'Automobile', 'BS002', 5),
(24, 'Industrie pharmaceutique', 'BS003', 5),
(25, 'Agroalimentaire', 'BS004', 5),
-- Items for 'Pays' (ID: 6)
(26, 'Tunisie', 'TN', 6),
(27, 'France', 'FR', 6);

INSERT INTO solution_entities (id,code, state, level, title, parentId)
VALUES (1,'admin_Solution', false, '0', 'Admin solution', '0');

INSERT INTO solution_compensation 
    (column_code, column_label, description, languageId) 
VALUES 
    ('pays', 'Pays', 'pays',2),
    ('ville', 'Ville', 'Code de la Région ou la Ville du bureau principal dont ils sont rattachés.',2),
    ('site', 'Site', 'L\'étendue géographique de la ou des fonctions sous la responsabilité du titulaire du poste (M: Multisite, S: un seul site).', 2),
    ('matricule', 'Matricule interne', 'Matricule qui identifie le titulaire au sein de votre entreprise. Ce code est spécifique à chaque titulaire.',2),   
    ('departement', 'Nom du département', 'Le nom du département dans lequel le titulaire exerce ses responsabilités.', 2),
    ('fonction', 'Intitulé de la fonction','Intitulé de la fonction actuelle dans l\'entreprise.',2),
	('niveau_interne', 'Grade/Niveau interne', 'Grade ou niveau actuel du titulaire dans votre entreprise.',2),
    ('genre', 'Genre', 'M: Male, F: Femelle.',2),
    ('date_naissance', 'Date de naissance', 'Date de naissance du titulaire.',2),
    ('date_embauche', "Date d'embauche", "Date d'embauche du titulaire.",2),
    ('code_fonction', 'Code de la fonction', "Le code du Domaine d'Activité du poste du titulaire, composé de trois lettres (par ex. HRH).",2),
    ('code_sous_fonction', 'Code de la Discipline', 'Le code de la Discipline correspondant au poste du titulaire, composé de trois chiffres (ex: 120).',2),
    ('chemin_collaborative', 'Chemin collaboratif ', 'Le niveau de Carrière correspondant au poste du titulaire (ex: M1).', 2),
    ('grade', 'Grade du poste', 'Le grade du poste du titulaire (ex: 10).',2),
    ('nombre_employes_supervises', 'Nombre de salariés supervisés', "Si la colonne 'point de carrière' contient 'M' et 'EX', cette valeur doit être différente de 0; si la colonne 'point de carrière' contient 'P', 'S', 'T', 'U' et 'W', cette valeur doit être égale à 0.", 2),
	('devise', 'Devise des éléments de rémunération', 'Devise dans laquelle sont exprimés les éléments de rémunération.',2),
    ('salaire_annuel_brut', 'Salaire annuel brut', 'Le salaire brut est la somme du salaire de base + les indemnités légales en équivalent temps plein avant toute déduction.',2),
    ('nombre_salaire_mensuel', 'Nombre de versements mensuels', 'Nombre de versements du salaire brut sur un an, y compris les mois supplémentaires de salaire fixe (13e/14e mois), en fonction de la réglementation et des pratiques de votre organisation.', 2),
    ('remuneration_heures_supplementaires', 'Type de rémunération des heures supplémentaires', 'La méthode de rémunération des heures supplémentaires: A - Salaire tout compris (pas de rémunération pour les heures supplémentaires), G - Garanti (éligible à la rémunération garantie des heures supplémentaires), I - Individuel (éligible à la rémunération des heures supplémentaires sur une base individuelle), N - Non éligible.',2),
    ('prime_anciennete', 'Prime d\'ancienneté', '',2),
    ('prime_scolarité', 'Prime de scolarité', 'Prime de scolarité',2),
    ('allocation_repas', 'Allocation repas', 'Valeur annuelle des tickets-repas ou des repas fournis au titulaire ou coût annuel payé par l organisation pour les déjeuners à la cantine.', 2),
    ('prime_logement', 'Prime de logement', 'Montant annuel payé séparément du Salaire Annuel Brut pour compenser un différentiel de coût de la vie ou des pressions sur le marché du travail dans une région particulière.', 2),
    ('prime_transport', 'Prime de transport', 'Montant annuel attribué au titre des frais de transport.',2),
    ('autres_primes', 'Autre primes versées au titre du dernier exercice', 'Autres primes (hors prime sur objectif) versées au titre du dernier exercice.', 2),
    ('indemnites_fixes_especes', 'Indemnités fixes', 'La valeur de toute autre indemnité fixe versée en espèces durant le cycle annuel en cours.', 2),
    ('eligibilite_bonus_performance', 'Eligibilité au bonus de performance', 'E: Éligible - veuillez compléter les colonnes relatives au montant du bonus de performance cible et réellement versé en pourcentage du salaire brut. N: Non éligible.',2),
    ('prime_performance_cible', 'Bonus de performance cible', "Le taux cible du bonus de performance à l'atteinte de 100% de l'objectif en pourcentage du salaire brut annuel.", 2),
    ('montant_prime_performance', 'Montant total du bonus de performance', "Le montant total du bonus de performance attribué au titre du dernier exercice fiscal. Pour les bonus qui impliquent plusieurs versements au cours d'une année, il s'agira du montant annuel total.", 2),
    ('commissions_eligibilite', 'Eligibilité aux commissions', 'E: Éligible - veuillez compléter les colonnes relatives au montant des commissions en pourcentage. N: Non éligible.',2),
    ('remuneration_variable_commerciale', 'Rémunération variable commerciale cible', 'Le taux cible de la rémunération variable commerciale en pourcentage du salaire annuel brut.',  2),
    ('montant_total_primes_ventes', 'Montant total des primes de ventes attribuées', 'Le montant des primes de ventes perçues au titre du dernier exercice fiscal.', 2),
    ('montant_total_commissions_ventes', 'Montant total des commissions de vente', 'Le montant des commissions perçues au titre du dernier exercice fiscal.',2),
    ('eligibilite_avantage_voiture', "Critères d'éligibilité à l'avantage voiture", "Les critères pour bénéficier d'un avantage voiture: S - Éligibilité en fonction du statut de l'emploi, N - Éligibilité en fonction de la nature de l'emploi/des exigences du poste.", 2),
    ('amortissement_voiture', 'Amortissement voiture', "Oui : si le collaborateur bénéficie d'un amortissement voiture contre l'utilisation de sa voiture personnelle. Non : Si non concerné.",2 ),
    ('frais_annuel_amortissement_voiture', 'Frais annuel amortissement voiture', "La valeur annuelle allouée au titulaire du poste pour l'utilisation de sa voiture personnelle.", 2),
	('eligibilite_allocation_voiture', 'Eligibilite allocation voiture', "Éligibilité à l’attribution de voiture', 'Indique si un individu ou un employé est éligible à l’attribution d’une voiture selon des critères prédéfinis",2 ),
    ('frais_annuel_allocation_voiture', 'Frais annuel allocation voiture', "Coût annuel de l’attribution de voiture', 'Représente le coût annuel total associé à l’attribution d’une voiture, y compris l’entretien, l’assurance et autres dépenses connexes", 2);
 
   INSERT INTO solution_compensation 
    (column_code, column_label, description, languageId) 
     VALUES
	 ('country', 'Country', 'country',1),
    ('city', 'City', 'Code of the Region or the main office city they are attached to.', 1),
    ('site', 'Site', 'The geographical scope of the role responsibilities (M: Multisite, S: single site).', 1),
    ('matricule', 'Internal ID', 'ID that identifies the individual within your company. This code is specific to each employee.', 1),   
    ('department', 'Department Name', 'The name of the department in which the employee works.', 1),
    ('function', 'Job Title','Current job title in the company.', 1),
    ('internal_grade', 'Internal Grade/Level', 'Current grade or level of the employee in your company.', 1),
    ('gender', 'Gender', 'M: Male, F: Female.', 1),
    ('birthday', 'Date of Birth', 'Employee\'s date of birth.', 1),
    ('hiring_date', "Hiring Date", "Employee's hiring date.", 1),
    ('function_code', 'Job Function Code', "The code of the job's activity domain, consisting of three letters (e.g., HRH).", 1),
    ('subfunction_code', 'Discipline Code', 'The code of the discipline related to the job, consisting of three digits (e.g., 120).', 1),
    ('collaborative_path', 'Collaborative Path', 'The career level corresponding to the position (e.g., M1).', 1),
    ('grade', 'Job Grade', 'The grade of the employee\'s position (e.g., 10).', 1),
    ('number_employees_supervised', 'Number of Employees Supervised', "If the 'career point' column contains 'M' and 'EX', this value must be different from 0; if it contains 'P', 'S', 'T', 'U', and 'W', this value must be 0.", 1),
    ('devise', 'Currency of Pay Elements', 'Currency in which pay elements are expressed.', 1),
    ('gross_annual_salary', 'Gross Annual Salary', 'The gross salary is the sum of base salary + legal allowances in full-time equivalent before any deduction.', 1),
    ('number_monthly_salary', 'Number of Monthly Payments', 'Number of payments of the gross annual salary over a year, including extra months of fixed salary (13th/14th month), as per regulation and company practices.', 1),
    ('type_overtime_pay', 'Overtime Pay Type', 'The overtime pay method: A - All-inclusive salary (no overtime pay), G - Guaranteed (eligible for guaranteed overtime pay), I - Individual (eligible for individual overtime pay), N - Not eligible.', 1),
    ('seniority_bonus', 'Seniority Bonus', '', 1),
    ('schooling_allowance', 'Schooling Allowance', 'Schooling allowance.', 1),
    ('meal_allowance', 'Meal Allowance', 'Annual value of meal tickets or meals provided to the employee or annual cost paid by the organization for canteen meals.', 1),
    ('location_allowance', 'Housing Allowance', 'Annual amount paid separately from Gross Annual Salary to compensate for living cost differences or labor market pressures in a specific region.', 1),
    ('transportation_allowance', 'Transportation Allowance', 'Annual amount allocated for transportation expenses.', 1),
    ('other_bonuses_awarded_last_year', 'Other Bonuses Awarded Last Year', 'Other bonuses (excluding target bonuses) awarded last year.', 1),
    ('fixed_allowances', 'Fixed Allowances', 'The value of any other fixed allowance paid in cash during the current annual cycle.', 1),
    ('eligibility_performance_bonus', 'Performance Bonus Eligibility', 'E: Eligible - please complete columns related to target and actual bonus amounts as a percentage of gross salary. N: Not eligible.', 1),
    ('target_performance_bonus', 'Target Performance Bonus', "The target rate for performance bonuses upon achieving 100% of the objective, as a percentage of gross annual salary.", 1),
    ('total_amount_performance_bonus_awarded', 'Total Performance Bonus Amount', "The total performance bonus amount awarded last fiscal year. For bonuses involving multiple payments over a year, this is the total annual amount.", 1),
    ('eligibility_commissions', 'Commissions Eligibility', 'E: Eligible - please complete columns related to commission amounts as a percentage. N: Not eligible.', 1),
    ('target_variable_sales_compensation', 'Target Variable Sales Compensation', 'The target rate of variable sales compensation as a percentage of gross annual salary.', 1),
    ('total_amount_sales_bonus_awarded', 'Total Sales Bonus Amount', 'The amount of sales bonuses received last fiscal year.', 1),
    ('total_amount_sales_commissions_awarded', 'Total Sales Commissions Amount', 'The amount of sales commissions received last fiscal year.', 1),
    ('car_benefit_eligibility', 'Car Benefit Eligibility', "Criteria for car benefits: S - Eligibility based on job status, N - Eligibility based on job requirements.", 1),
    ('car_depreciation', 'Car Depreciation', "Yes: if the employee benefits from car depreciation for using their personal car. No: if not applicable.", 1),
    ('annual_cost_car_depreciation', 'Annual Car Depreciation Cost', "Annual value allocated to the employee for using their personal car.", 1),
	('car_allocation_eligibility', 'Car allocation eligibility', 'Indicates whether an individual or employee is eligible for car allocation based on predefined criteria.', 1),
	('annual_cost_car_allocation', 'Annual cost car allocation', 'Represents the total annual cost associated with the allocation of a car, including maintenance, insurance, and other related expenses.', 1);