use socle;
-- initialise languages
INSERT INTO languages (id, language, tag) VALUES 
(1, 'English', 'en'),
(2, 'French', 'fr');
-- initialise language solution
INSERT INTO solution_languages (id, active, defaultLanguage, languagesId) VALUES 
(1, 'true', 0, '1'),
(2, 'true', 1, '2');
INSERT INTO solution_menu (id, menuCode, menuLibelle, parentMenu, menu_type, menu_position) VALUES
-- Home Section
(1, 'home', 'Home',NULL, 'menu',1),
(2, 'home_administration', 'Administration', 'home', 'subMenu',1),
(3, 'home_administration_clients', ' Number  of Clients ', 'home_administration', 'widget',1),
(4, 'home_administration_secteurs', ' Clients per Sector', 'home_administration', 'widget',1),
(5, 'home_administration_subscription', 'Subscription  per clients ', 'home_administration', 'widget',1), 
(6, 'home_administrationemployees_per_region', 'Employees per Region', 'home_administration', 'widget',1),
(7, 'home_indicators', 'Indicators','home', 'subMenu',1),
(8, 'home_indicateurs_number_of_employees', 'Number of Employees', 'home_indicators', 'widget',1),
(9, 'home_administration_nbCollaborateursGender', 'Number of Employees by Gender', 'home_indicators', 'widget',1),

(10, 'home_indicateurs_payroll', 'Payroll','home_indicators', 'widget',1),
(11, 'home_indicateurs_average_salaries_by_career_path', 'Average Salaries by Career Path', 'home_indicators', 'widget',1),
(12, 'home_indicateurs_supervision_rate', 'Supervision Rate', 'home_indicators', 'widget',1),
-- Compensation Section
(13, 'company_compensation', 'Company Compensation', NULL, 'menu',1),
-- Quiz Section
(14, 'company_quiz', 'HR Policy and Practices', NULL, 'menu',0),
(15, 'quiz_current_sector', 'Quiz current Sector ','company_quiz', 'option',0),  
(16, 'quiz_market', 'Quiz by Market', 'company_quiz', 'option',0),
(17, 'quiz_selected_sector', 'Quiz by Selected Sector', 'company_quiz', 'option',0),  
-- Report Section
(18, 'report', 'Report', NULL, 'menu',0),
-- My Company Section
(19, 'myCompany', 'My Company', NULL, 'menu',1),
(20, 'myCompany_informations', 'Information', 'myCompany', 'menu',1),
(21, 'myCompany_users', 'Users', 'myCompany', 'menu',1),
(22, 'myCompany_entities', 'Entities', 'myCompany', 'menu',1),
(23, 'myCompany_profiles', 'Profiles','myCompany', 'menu',1),
(24, 'myCompany_configuration', 'Configuration', 'myCompany', 'menu',1),
(25, 'myCompany_settings', 'Settings', 'myCompany', 'menu',1),
(26, 'myCompany_settings_language', 'Language', 'myCompany_settings', 'subMenu',1),
-- My Clients Section
(27, 'myClients', 'My Clients', NULL, 'menu',1),
(28, 'myClients_clients', 'Clients', 'myClients', 'menu',1),
(29, 'client_informations', 'Information','myClients_clients', 'subMenu',1),
(30, 'client_users', 'Users', 'myClients_clients', 'subMenu',1),
(31, 'client_entities', 'Entities', 'myClients_clients', 'subMenu',1),
(32, 'client_profiles', 'Profiles', 'myClients_clients', 'subMenu',1),
(33, 'client_configuration', 'Configuration', 'myClients_clients', 'subMenu',1),
(34, 'myClients_prospection', 'Prospecting', 'myClients', 'menu',1),
-- Administration Section
(35, 'administration', 'Administration', NULL, 'menu',1),
(36, 'administration_settings', 'Settings', 'administration', 'menu',1),
(37, 'administration_settings_language', 'Language', 'administration_settings', 'subMenu',1),
(38, 'administration_settings_country', 'Country', 'administration_settings', 'subMenu',1),
(39, 'administration_settings_business-sector', 'Business Sector', 'administration_settings', 'subMenu',1),
(40, 'administration_settings_turnover', 'Turnover', 'administration_settings', 'subMenu',1),
(41, 'administration_settings_geographic-extent', 'Geographic Extent', 'administration_settings', 'subMenu',1),
(42, 'administration_settings_company-size', 'Company Size', 'administration_settings', 'subMenu',1),
(43, 'administration_settings_value-chain', 'Value Chain','administration_settings', 'subMenu',1),
(44, 'administration_entities', 'Entities', 'administration', 'menu',1),
(45, 'administration_subscription', 'Subscription', 'administration', 'menu',1);-- changer l'ordre
INSERT INTO solution_subscription (id,subscription_code,subscription_type) VALUES 
(1,'on_the_menu','On The Menu'),
(2,'essential','Essential'),
(3,'advanced','Advanced');
  
-- Insert all rights for modules 
INSERT INTO solution_menu_rights (right_code, right_label, menuCode) VALUES
-- Compensation
('compensation_import', 'Import', 'company_compensation'),
('compensation_search', 'Search', 'company_compensation'),
('compensation_export', 'Export', 'company_compensation'),
('compensation_create', 'Create', 'company_compensation'),
('compensation_delete', 'Delete', 'company_compensation'),
('compensation_update', 'Update', 'company_compensation'),
('compensation_view' , 'View',   'company_compensation'),
-- HR Policy and Practices
('quiz_Submit', 'Submit', 'company_quiz'),
('quiz_View', 'View', 'company_quiz'),
-- Report 
('report_create', 'Create', 'report'),
('report_View', 'View', 'report'),
('report_update', 'Update', 'report'),
('report_delete', 'Delete', 'report'),
('report_upload', 'Upload', 'report'),
-- Informations company
('company_Informations_update', 'Update', 'myCompany_informations'),
-- Users company
( 'company_user_create', 'Create', 'myCompany_users'),
('company_user_update', 'Update', 'myCompany_users'),
('company_user_delete', 'Delete', 'myCompany_users'),
('company_user_desactivate', 'Desactivate', 'myCompany_users'),
('company_user_activity', 'Activity', 'myCompany_users'),
-- Entities company
('company_entites_Create', 'Create', 'myCompany_entities'),
('company_entites_update', 'Update', 'myCompany_entities'),
('company_entites_delete', 'Delete', 'myCompany_entities'),
-- Profiles company
('company_profil_Create', 'Create', 'myCompany_profiles'),
('company_profil_update', 'Update', 'myCompany_profiles'),
('company_profil_delete', 'Delete', 'myCompany_profiles'),
-- Languages company
('company_language_activate', 'Activate', 'myCompany_settings_language');
INSERT INTO solution_setting_country (id, code, active) VALUES
(1, 'TN', 1),
(2, 'FR', 1);
INSERT INTO solution_setting_country_translate (id, label, countryCode, languageId) VALUES
(1, 'Tunisia', 'TN', 1),   -- Traduction en anglais pour le pays TN
(2, 'Tunisie', 'TN', 2),   -- Traduction en français pour le pays TN
(3, 'France', 'FR', 1),    -- Traduction en anglais pour le pays FR
(4, 'France', 'FR', 2);    -- Traduction en français pour le pays FR
INSERT INTO solution_setting_business_sector (id, code) VALUES
(1, 'BS001'),
(2, 'BS002'),
(3, 'BS003'),
(4, 'BS004');
INSERT INTO solution_setting_business_sector_translate (id, label, businessSectorCode, languageId) VALUES
(1, 'IT', 'BS001', 1),    
(2, 'Informatique', 'BS001', 2),   
(3, 'Automobile', 'BS002', 1),    
(4, 'Automobile', 'BS002', 2), 
(5, 'Pharmaceutical industry', 'BS003', 1),     
(6, 'Industrie pharmaceutique', 'BS003', 2),
(7, 'Agrifood', 'BS004', 1),   
(8, 'Agroalimentaire', 'BS004', 2);
  
-- insert sub Sector
INSERT INTO solution_setting_sub_sector(id,code,businessSectorCode) VALUES 
(1 , 'SS001' ,'BS001') ,
(2 , 'SS002' ,'BS002'),
(3 , 'SS003' ,'BS003'),
(4 , 'SS004' ,'BS004');
INSERT INTO solution_setting_sub_sector_translate(id,Label,subSectorCode,languageId) VALUES
(1,'Digital','SS001',1),(2,'Digital','SS001',2),
(3,'Automobile','SS002',1),(4,'Automobile','SS002',2),
(5,'Pharma','SS003',1),(6,'Pharma','SS003',2),
(7,'Agro','SS004',1),(8,'Agro','SS004',2);
INSERT INTO solution_setting_sales_turnover (id, code) VALUES
(1, 'CA001'),
(2, 'CA002'),
(3, 'CA003'),
(4, 'CA004'),
(5, 'CA005');
INSERT INTO solution_setting_sales_turnover_translate (id, label, salesTurnoverCode, languageId) VALUES
(1, '1 - 10000', 'CA001', 1),    
(2, '1 - 10000', 'CA001', 2),   
(3, '10000 - 100000', 'CA002', 1),    
(4, '10000 - 100000', 'CA002', 2), 
(5, '100000 - 500000', 'CA003', 1),     
(6, '100000 - 500000', 'CA003', 2),
(7, '500000 - 1000000', 'CA004', 1),   
(8, '500000 - 1000000', 'CA004', 2), 
(9, 'Over 100,000', 'CA005', 1),   
(10, 'Plus de 100000', 'CA005', 2);  
INSERT INTO solution_setting_company_size (id, code) VALUES
(1, 'CS001'),
(2, 'CS002'),
(3, 'CS003'),
(4, 'CS004'),
(5, 'CS005'),
(6, 'CS006'),
(7, 'CS007'),
(8, 'CS008'),
(9, 'CS009'),
(10, 'CS0010');
INSERT INTO solution_setting_company_size_translate (id, label, companySizeCode, languageId) VALUES
(1, 'Less than 10', 'CS001', 1),    
(2, 'Moins de 10', 'CS001', 2),   
(3, 'Between 11 and 20', 'CS002', 1),    
(4, 'Entre 11 et 20', 'CS002', 2), 
(5, 'Between 21 and 30', 'CS003', 1),     
(6, 'Entre 21 et 30', 'CS003', 2),
(7, 'Between 31 and 50', 'CS004', 1),   
(8, 'Entre 31 et 50', 'CS004', 2), 
(9, 'Between 51 and 100', 'CS005', 1),   
(10, 'Entre 51 et 100', 'CS005', 2),  
(11, 'Between 101 and 300', 'CS006', 1),    
(12, 'Entre 101 et 300', 'CS006', 2),   
(13, 'Between 301 and 500', 'CS007', 1),    
(14, 'Entre 301 et 500', 'CS007', 2), 
(15, 'Between 501 and 1000', 'CS008', 1),     
(16, 'Entre 501 et 1000', 'CS008', 2),
(17, 'Between 1001 and 2000', 'CS009', 1),   
(18, 'Entre 1001 et 2000', 'CS009', 2), 
(19, 'Over 2001', 'CS0010', 1),   
(20, 'Plus de 2001', 'CS0010', 2);
 
INSERT INTO solution_setting_value_chain (id, code) VALUES
(1, 'VC001'),
(2, 'VC002');
INSERT INTO solution_setting_value_chain_translate (id, label, valueChainCode, languageId) VALUES
(1, 'Full control of the entire value chain', 'VC001', 1),    
(2, 'Contrôle total de toute la chaine de valeur', 'VC001', 2),   
(3, 'Partial control of the value chain', 'VC002', 1),    
(4, 'Contrôle partiel de la chaine de valeur', 'VC002', 2);
INSERT INTO solution_setting_geographic_extent (id, code) VALUES
(1, 'GE001'),
(2, 'GE002'),
(3, 'GE003'),
(4, 'GE004');
INSERT INTO solution_setting_geographic_extent_translate (id, label, geographicExtentCode, languageId) VALUES
(1, 'Present in one country', 'GE001', 1),    
(2, 'Présent sur un seul pays', 'GE001', 2),   
(3, 'Present in several countries of the same region', 'GE002', 1),    
(4, 'Présent sur plusieurs pays d’une même région', 'GE002', 2), 
(5, 'Present in several countries on two different continents', 'GE003', 1),     
(6, 'Présent sur plusieurs pays de deux continents différents', 'GE003', 2),
(7, 'Present on more than two continents', 'GE004', 1),   
(8, 'Présent sur plus de deux continents', 'GE004', 2);
INSERT INTO solution_entities (id,entity_code, state, entity_level, title, parentId) VALUES 
(1,'admin_Solution', false, '0', 'Admin solution', '0');

INSERT INTO  solution_compensation_informations 
    (column_code, column_label, description, languageId) 
VALUES 
    ('pays', 'Pays', 'pays',2),
    ('ville', 'Ville', 'Code de la Région ou la Ville du bureau principal dont ils sont rattachés.',2),
    ('site', 'Site', 'L\'étendue géographique de la ou des fonctions sous la responsabilité du titulaire du poste (M: Multisite, S: un seul site).', 2),
    ('matricule', 'Matricule interne', 'Matricule qui identifie le titulaire au sein de votre entreprise. Ce code est spécifique à chaque titulaire.',2),   
    ('departement', 'Nom du département', 'Le nom du département dans lequel le titulaire exerce ses responsabilités.', 2),
    ('fonction', 'Intitulé de la fonction','Intitulé de la fonction actuelle dans l\'entreprise.',2),
	('niveau_interne', 'Grade/Niveau interne', 'Grade ou niveau actuel du titulaire dans votre entreprise.',2),
    ('genre', 'Genre', 'M: Male, F: Femelle.',2),
    ('date_naissance', 'Date de naissance', 'Date de naissance du titulaire.',2),
    ('date_embauche', "Date d'embauche", "Date d'embauche du titulaire.",2),
    ('code_fonction', 'Code de la fonction', "Le code du Domaine d'Activité du poste du titulaire, composé de trois lettres (par ex. HRH).",2),
    ('code_sous_fonction', 'Code de la Discipline', 'Le code de la Discipline correspondant au poste du titulaire, composé de trois chiffres (ex: 120).',2),
    ('chemin_collaborative', 'Chemin collaboratif ', 'Le niveau de Carrière correspondant au poste du titulaire (ex: M1).', 2),
    ('grade', 'Grade du poste', 'Le grade du poste du titulaire (ex: 10).',2),
    ('nombre_employes_supervises', 'Nombre de salariés supervisés', "Si la colonne 'point de carrière' contient 'M' et 'EX', cette valeur doit être différente de 0; si la colonne 'point de carrière' contient 'P', 'S', 'T', 'U' et 'W', cette valeur doit être égale à 0.", 2),
	('devise', 'Devise des éléments de rémunération', 'Devise dans laquelle sont exprimés les éléments de rémunération.',2),
    ('salaire_annuel_brut', 'Salaire annuel brut', 'Le salaire brut est la somme du salaire de base + les indemnités légales en équivalent temps plein avant toute déduction.',2),
    ('nombre_salaire_mensuel', 'Nombre de versements mensuels', 'Nombre de versements du salaire brut sur un an, y compris les mois supplémentaires de salaire fixe (13e/14e mois), en fonction de la réglementation et des pratiques de votre organisation.', 2),
    ('remuneration_heures_supplementaires', 'Type de rémunération des heures supplémentaires', 'La méthode de rémunération des heures supplémentaires: A - Salaire tout compris (pas de rémunération pour les heures supplémentaires), G - Garanti (éligible à la rémunération garantie des heures supplémentaires), I - Individuel (éligible à la rémunération des heures supplémentaires sur une base individuelle), N - Non éligible.',2),
    ('prime_anciennete', 'Prime d\'ancienneté', '',2),
    ('prime_scolarité', 'Prime de scolarité', 'Prime de scolarité',2),
    ('allocation_repas', 'Allocation repas', 'Valeur annuelle des tickets-repas ou des repas fournis au titulaire ou coût annuel payé par l organisation pour les déjeuners à la cantine.', 2),
    ('prime_logement', 'Prime de logement', 'Montant annuel payé séparément du Salaire Annuel Brut pour compenser un différentiel de coût de la vie ou des pressions sur le marché du travail dans une région particulière.', 2),
    ('prime_transport', 'Prime de transport', 'Montant annuel attribué au titre des frais de transport.',2),
    ('autres_primes', 'Autre primes versées au titre du dernier exercice', 'Autres primes (hors prime sur objectif) versées au titre du dernier exercice.', 2),
    ('indemnites_fixes_especes', 'Indemnités fixes', 'La valeur de toute autre indemnité fixe versée en espèces durant le cycle annuel en cours.', 2),
    ('eligibilite_bonus_performance', 'Eligibilité au bonus de performance', 'E: Éligible - veuillez compléter les colonnes relatives au montant du bonus de performance cible et réellement versé en pourcentage du salaire brut. N: Non éligible.',2),
    ('prime_performance_cible', 'Bonus de performance cible', "Le taux cible du bonus de performance à l'atteinte de 100% de l'objectif en pourcentage du salaire brut annuel.", 2),
    ('montant_prime_performance', 'Montant total du bonus de performance', "Le montant total du bonus de performance attribué au titre du dernier exercice fiscal. Pour les bonus qui impliquent plusieurs versements au cours d'une année, il s'agira du montant annuel total.", 2),
    ('commissions_eligibilite', 'Eligibilité aux commissions', 'E: Éligible - veuillez compléter les colonnes relatives au montant des commissions en pourcentage. N: Non éligible.',2),
    ('remuneration_variable_commerciale', 'Rémunération variable commerciale cible', 'Le taux cible de la rémunération variable commerciale en pourcentage du salaire annuel brut.',  2),
    ('montant_total_primes_ventes', 'Montant total des primes de ventes attribuées', 'Le montant des primes de ventes perçues au titre du dernier exercice fiscal.', 2),
    ('montant_total_commissions_ventes', 'Montant total des commissions de vente', 'Le montant des commissions perçues au titre du dernier exercice fiscal.',2),
    ('eligibilite_avantage_voiture', "Critères d'éligibilité à l'avantage voiture", "Les critères pour bénéficier d'un avantage voiture: S - Éligibilité en fonction du statut de l'emploi, N - Éligibilité en fonction de la nature de l'emploi/des exigences du poste.", 2),
    ('amortissement_voiture', 'Amortissement voiture', "Oui : si le collaborateur bénéficie d'un amortissement voiture contre l'utilisation de sa voiture personnelle. Non : Si non concerné.",2 ),
    ('frais_annuel_amortissement_avantage_voiture', 'Frais annuel amortissement voiture', "La valeur annuelle allouée au titulaire du poste pour l'utilisation de sa voiture personnelle.", 2),
	('eligibilite_allocation_voiture', 'Eligibilite allocation voiture', "Éligibilité à l’attribution de voiture', 'Indique si un individu ou un employé est éligible à l’attribution d’une voiture selon des critères prédéfinis",2 ),
    ('frais_annuel_allocation_voiture', 'Frais annuel allocation voiture', "Coût annuel de l’attribution de voiture', 'Représente le coût annuel total associé à l’attribution d’une voiture, y compris l’entretien, l’assurance et autres dépenses connexes", 2);

   INSERT INTO  solution_compensation_informations 
    (column_code, column_label, description, languageId) 
     VALUES
	 ('country', 'Country', 'country',1),
    ('city', 'City', 'Code of the Region or the main office city they are attached to.', 1),
    ('site', 'Site', 'The geographical scope of the role responsibilities\n(M: Multisite, S: single site).', 1),
    ('matricule', 'Internal ID', 'ID that identifies the individual within your company. This code is specific to each employee.', 1),   
    ('department', 'Department Name', 'The name of the department in which the employee works.', 1),
    ('function', 'Job Title','Current job title in the company.', 1),
    ('internal_grade', 'Internal Grade/Level', 'Current grade or level of the employee in your company.', 1),
    ('gender', 'Gender', 'M: Male, F: Female.', 1),
    ('birthday', 'Date of Birth', 'Employee\'s date of birth.', 1),
    ('hiring_date', "Hiring Date", "Employee's hiring date.", 1),
    ('function_code', 'Job Function Code', "The code of the job's activity domain, consisting of three letters (e.g., HRH).", 1),
    ('subfunction_code', 'Discipline Code', 'The code of the discipline related to the job, consisting of three digits (e.g., 120).', 1),
    ('collaborative_path', 'Collaborative Path', 'The career level corresponding to the position (e.g., M1).', 1),
    ('grade', 'Job Grade', 'The grade of the employee\'s position (e.g., 10).', 1),
    ('number_employees_supervised', 'Number of Employees Supervised', "If the 'career point' column contains 'M' and 'EX', this value must be different from 0; if it contains 'P', 'S', 'T', 'U', and 'W', this value must be 0.", 1),
    ('devise', 'Currency of Pay Elements', 'Currency in which pay elements are expressed.', 1),
    ('gross_annual_salary', 'Gross Annual Salary', 'The gross salary is the sum of base salary + legal allowances in full-time equivalent before any deduction.', 1),
    ('number_monthly_salary', 'Number of Monthly Payments', 'Number of payments of the gross annual salary over a year, including extra months of fixed salary (13th/14th month), as per regulation and company practices.', 1),
    ('type_overtime_pay', 'Overtime Pay Type', 'The overtime pay method: A - All-inclusive salary (no overtime pay), G - Guaranteed (eligible for guaranteed overtime pay), I - Individual (eligible for individual overtime pay), N - Not eligible.', 1),
    ('seniority_bonus', 'Seniority Bonus', '', 1),
    ('schooling_allowance', 'Schooling Allowance', 'Schooling allowance.', 1),
    ('meal_allowance', 'Meal Allowance', 'Annual value of meal tickets or meals provided to the employee or annual cost paid by the organization for canteen meals.', 1),
    ('location_allowance', 'Housing Allowance', 'Annual amount paid separately from Gross Annual Salary to compensate for living cost differences or labor market pressures in a specific region.', 1),
    ('transportation_allowance', 'Transportation Allowance', 'Annual amount allocated for transportation expenses.', 1),
    ('other_bonuses_awarded_last_year', 'Other Bonuses Awarded Last Year', 'Other bonuses (excluding target bonuses) awarded last year.', 1),
    ('fixed_allowances', 'Fixed Allowances', 'The value of any other fixed allowance paid in cash during the current annual cycle.', 1),
    ('eligibility_performance_bonus', 'Performance Bonus Eligibility', 'E: Eligible - please complete columns related to target and actual bonus amounts as a percentage of gross salary. N: Not eligible.', 1),
    ('target_performance_bonus', 'Target Performance Bonus', "The target rate for performance bonuses upon achieving 100% of the objective, as a percentage of gross annual salary.", 1),
    ('total_amount_performance_bonus_awarded', 'Total Performance Bonus Amount', "The total performance bonus amount awarded last fiscal year. For bonuses involving multiple payments over a year, this is the total annual amount.", 1),
    ('eligibility_commissions', 'Commissions Eligibility', 'E: Eligible - please complete columns related to commission amounts as a percentage. N: Not eligible.', 1),
    ('target_variable_sales_compensation', 'Target Variable Sales Compensation', 'The target rate of variable sales compensation as a percentage of gross annual salary.', 1),
    ('total_amount_sales_bonus_awarded', 'Total Sales Bonus Amount', 'The amount of sales bonuses received last fiscal year.', 1),
    ('total_amount_sales_commissions_awarded', 'Total Sales Commissions Amount', 'The amount of sales commissions received last fiscal year.', 1),
    ('car_benefit_eligibility', 'Car Benefit Eligibility', "Criteria for car benefits: S - Eligibility based on job status, N - Eligibility based on job requirements.", 1),
    ('car_depreciation', 'Car Depreciation', "Yes: if the employee benefits from car depreciation for using their personal car. No: if not applicable.", 1),
    ('annual_cost_car_depreciation', 'Annual Car Depreciation Cost', "Annual value allocated to the employee for using their personal car.", 1),
	('car_allocation_eligibility', 'Car allocation eligibility', 'Indicates whether an individual or employee is eligible for car allocation based on predefined criteria.', 1),
	('annual_cost_car_allocation', 'Annual cost car allocation', 'Represents the total annual cost associated with the allocation of a car, including maintenance, insurance, and other related expenses.', 1);